@extends('layouts.app')

@section('title', 'Koordinasi')

@section('content')
<div>
    <h2 class="text-3xl font-bold mb-6">Koordinasi Internal & Eksternal</h2>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Aduan</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tipe</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Penerima</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Waktu</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($coordinations as $coordination)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        {{ $coordination->complaint->ticket_number }}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        {{ ucfirst($coordination->type) }}
                        @if($coordination->type === 'external')
                            - {{ strtoupper($coordination->external_type) }}
                        @endif
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        {{ $coordination->recipient_name ?? '-' }}<br>
                        <span class="text-xs text-gray-500">{{ $coordination->recipient_phone ?? $coordination->recipient_email ?? '-' }}</span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 py-1 text-xs rounded-full
                            {{ $coordination->status === 'completed' ? 'bg-green-100 text-green-800' : '' }}
                            {{ $coordination->status === 'pending' ? 'bg-yellow-100 text-yellow-800' : '' }}">
                            {{ ucfirst($coordination->status) }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        {{ $coordination->created_at->format('d/m/Y H:i') }}
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="px-6 py-4 text-center text-gray-500">Tidak ada data koordinasi</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $coordinations->links() }}
    </div>
</div>
@endsection

