@extends('layouts.app')

@section('title', 'Puskodal 110')

@section('content')
@push('styles')
<style>
    .map-icon i {
        width: 16px;
        height: 16px;
        display: inline-block;
    }
    .map-marker {
        display: flex;
        align-items: center;
        justify-content: center;
        border: 2px solid #0b0e14;
        border-radius: 999px;
        box-shadow: 0 0 15px rgba(0,0,0,0.35);
    }
    .map-marker--critical {
        background-color: #ef4444;
        color: #fff;
        width: 40px;
        height: 40px;
    }
    .map-marker--warning {
        background-color: #f59e0b;
        color: #111827;
        width: 34px;
        height: 34px;
    }
    .map-marker--info {
        background-color: #2563eb;
        color: #fff;
        width: 34px;
        height: 34px;
    }
</style>
@endpush
@php
    $stats = $stats ?? [];
    if (empty($stats)) {
        $stats = [
            'total_complaints' => 1287,
            'processing_complaints' => 24,
            'active_officers' => 342,
            'average_response' => '3m 47s',
        ];
    }

    $recentComplaints = $recentComplaints ?? collect();
    if ($recentComplaints->isEmpty()) {
        $recentComplaints = collect([
            (object)[
                'ticket_number' => 'ADU-20250101-XF91',
                'location' => (object)['address' => 'Jl. MH Thamrin, Jakarta Pusat'],
                'category' => 'emergency_police',
                'dispatches' => collect([(object)['unit_type' => 'Patroli Sabhara']]),
                'status' => 'processing',
            ],
            (object)[
                'ticket_number' => 'ADU-20250101-YZ12',
                'location' => (object)['address' => 'Jl. Raya Bogor KM 25'],
                'category' => 'emergency_fire',
                'dispatches' => collect([(object)['unit_type' => 'Damkar']]),
                'status' => 'dispatched',
            ],
            (object)[
                'ticket_number' => 'ADU-20250101-ZP77',
                'location' => (object)['address' => 'Jl. Sudirman, Bandung'],
                'category' => 'emergency_medical',
                'dispatches' => collect([(object)['unit_type' => 'Ambulans PSC']]),
                'status' => 'pending',
            ],
        ]);
    }

    $heatmapData = $heatmapData ?? [
        [
            'lat' => -6.2088,
            'lng' => 106.8456,
            'count' => 32,
            'category' => 'emergency_police',
            'icon' => 'flame',
            'label' => 'Kebakaran Gedung',
            'description' => 'Jl. Sudirman No. 45 (Zone B2)',
            'status' => 'Critical • ETA 2m',
            'color' => 'red',
        ],
        [
            'lat' => -6.1380,
            'lng' => 106.8317,
            'count' => 18,
            'category' => 'panic_button',
            'icon' => 'bell-ring',
            'label' => 'Panic Button Bank',
            'description' => 'Bank BCA Mangga Dua',
            'status' => 'Verifikasi CCTV',
            'color' => 'amber',
        ],
        [
            'lat' => -6.2000,
            'lng' => 106.9167,
            'count' => 12,
            'category' => 'patrol_unit',
            'icon' => 'car',
            'label' => 'Unit 801',
            'description' => 'Patroli Sabhara - Rute Thamrin',
            'status' => 'On Scene',
            'color' => 'blue',
        ],
    ];

    $incomingAlerts = [
        [
            'label' => 'Call 110 • Darurat',
            'type' => 'phone',
            'icon' => 'phone-call',
            'icon_color' => 'text-red-400',
            'level' => 'critical',
            'desc' => 'Suara teriakan, indikasi KDRT atau penganiayaan.',
            'location' => 'Tanah Abang, Jakpus',
            'time' => 'Baru saja',
        ],
        [
            'label' => 'Panic Button • Bank',
            'type' => 'panic',
            'icon' => 'alert-triangle',
            'icon_color' => 'text-amber-400',
            'level' => 'warning',
            'desc' => 'BCA KCP Mangga Dua. Tombol Teller 2.',
            'location' => 'Mangga Dua, Jakut',
            'time' => '2m lalu',
        ],
        [
            'label' => 'WhatsApp Official',
            'type' => 'chat',
            'icon' => 'message-square',
            'icon_color' => 'text-green-400',
            'level' => 'info',
            'desc' => 'Laporan kemacetan akibat pohon tumbang.',
            'location' => 'Jl. Ahmad Yani',
            'time' => '5m lalu',
        ],
    ];
@endphp

<!-- Header -->
<div class="flex flex-wrap gap-4 justify-between items-center">
    <div>
        <p class="text-xs text-gray-500">Nasional • Polda → Polres → Polsek</p>
        <h2 class="text-3xl font-bold tracking-tight text-white">Puskodal 110</h2>
    </div>
    <div class="flex gap-2 text-xs text-gray-400">
        <span class="flex items-center gap-1"><span class="w-2 h-2 rounded-full bg-green-500 animate-pulse"></span> Sistem aktif</span>
        <span>•</span>
        <span>Level akses: Nasional</span>
    </div>
</div>

<!-- Stats -->
<div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-4 mb-6">
    <a href="{{ route('complaints.index') }}" class="bg-surface border border-border rounded-xl p-4 hover:border-blue-500/50 transition group">
        <div class="flex justify-between items-center mb-2">
            <div class="p-2 bg-blue-500/10 text-blue-400 rounded-lg group-hover:bg-blue-500/20 transition"><i data-lucide="phone-call" class="w-4 h-4"></i></div>
            <span class="text-[10px] text-green-400">+12%</span>
        </div>
        <p class="text-3xl font-semibold text-white">{{ number_format($stats['total_complaints'] ?? 0) }}</p>
        <p class="text-xs text-gray-500 mt-1">Total aduan (24 jam)</p>
    </a>
    <div class="bg-surface border border-border rounded-xl p-4">
        <div class="flex justify-between items-center mb-2">
            <div class="p-2 bg-red-500/10 text-red-400 rounded-lg"><i data-lucide="siren" class="w-4 h-4"></i></div>
            <span class="text-[10px] text-red-400 animate-pulse">Live</span>
        </div>
        <p class="text-3xl font-semibold text-white">{{ $stats['processing_complaints'] ?? 0 }}</p>
        <p class="text-xs text-gray-500 mt-1">Insiden kritis aktif</p>
    </div>
    <a href="{{ route('officers.index') }}" class="bg-surface border border-border rounded-xl p-4 hover:border-indigo-500/50 transition group">
        <div class="flex justify-between items-center mb-2">
            <div class="p-2 bg-indigo-500/10 text-indigo-400 rounded-lg group-hover:bg-indigo-500/20 transition"><i data-lucide="shield" class="w-4 h-4"></i></div>
        </div>
        <p class="text-3xl font-semibold text-white">{{ $stats['active_officers'] ?? 0 }}</p>
        <p class="text-xs text-gray-500 mt-1">Personil on-duty</p>
    </a>
    <a href="{{ route('performance.index') }}" class="bg-surface border border-border rounded-xl p-4 hover:border-amber-500/50 transition group">
        <div class="flex justify-between items-center mb-2">
            <div class="p-2 bg-amber-500/10 text-amber-400 rounded-lg group-hover:bg-amber-500/20 transition"><i data-lucide="clock" class="w-4 h-4"></i></div>
        </div>
        <p class="text-3xl font-semibold text-white">{{ $stats['average_response'] ?? '4m 12s' }}</p>
        <p class="text-xs text-gray-500 mt-1">Rata-rata respon</p>
    </a>
</div>

<!-- Main grid -->
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6 h-full">
    <!-- Map -->
    <div class="lg:col-span-2 bg-surface border border-border rounded-2xl relative overflow-hidden">
        <div class="absolute top-4 left-4 glass-panel px-3 py-2 rounded-lg flex items-center gap-3 text-xs">
            <span class="flex items-center gap-1 text-white"><span class="w-2 h-2 rounded-full bg-red-500 animate-ping"></span> Live tracking</span>
            <span class="text-gray-500">Radius nasional</span>
        </div>
        <div id="map" class="w-full h-[420px]"></div>
    </div>

    <!-- Alerts -->
    <div class="flex flex-col gap-4">
        <div class="bg-surface border border-border rounded-2xl flex-1 overflow-hidden">
            <div class="px-4 py-3 border-b border-border flex justify-between">
                <h3 class="text-xs font-semibold text-gray-300 uppercase tracking-wide">Aduan Real-time</h3>
                <span class="text-[10px] text-blue-400 bg-blue-500/10 px-2 py-0.5 rounded-full border border-blue-500/20">Auto tracking aktif</span>
            </div>
            <div class="p-3 space-y-2 max-h-[280px] overflow-y-auto">
                @foreach($incomingAlerts as $alert)
                    <button type="button"
                            class="js-alert-card w-full text-left p-3 rounded-xl border border-white/5 bg-white/5 hover:border-{{ $alert['level'] === 'critical' ? 'red' : ($alert['level'] === 'warning' ? 'amber' : 'blue') }}-500/30 transition focus:outline-none focus:ring-2 focus:ring-{{ $alert['level'] === 'critical' ? 'red' : ($alert['level'] === 'warning' ? 'amber' : 'blue') }}-500/40"
                            data-alert="{{ $alert['label'] }}"
                            data-location="{{ $alert['location'] }}"
                            data-type="{{ $alert['type'] }}">
                        <div class="flex justify-between items-start text-xs mb-1">
                            <div class="flex items-center gap-2 text-white">
                                <span class="{{ $alert['icon_color'] }}">
                                    <i data-lucide="{{ $alert['icon'] }}" class="w-3.5 h-3.5"></i>
                                </span>
                                <span>{{ $alert['label'] }}</span>
                            </div>
                            <span class="text-gray-500">{{ $alert['time'] }}</span>
                        </div>
                        <p class="text-xs text-gray-400">{{ $alert['desc'] }}</p>
                        <p class="text-[10px] text-indigo-400 mt-1">{{ $alert['location'] }}</p>
                    </button>
                @endforeach
            </div>
        </div>

        <a href="{{ route('cctvs.index') }}" class="bg-surface border border-border rounded-2xl p-4 hover:border-purple-500/50 transition group">
            <div class="flex justify-between items-center mb-3">
                <h3 class="text-xs font-semibold text-gray-300 uppercase tracking-wide">CCTV Gateway</h3>
                <span class="text-[10px] text-red-400 flex items-center gap-1"><span class="w-2 h-2 rounded-full bg-red-500 animate-pulse"></span> REC</span>
            </div>
            <div class="bg-black rounded-xl h-40 flex items-center justify-center text-gray-500 text-xs border border-gray-800 group-hover:border-purple-500/30 transition">
                <div class="text-center">
                    <i data-lucide="video" class="w-8 h-8 mx-auto mb-2 text-gray-600"></i>
                    <p>Live feed akan tampil di sini</p>
                    <p class="text-[10px] mt-1 text-gray-600">Klik untuk lihat semua CCTV</p>
                </div>
            </div>
        </a>
    </div>
</div>

<!-- Quick Access to Features -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
    <a href="{{ route('performance.index') }}" class="bg-surface border border-border rounded-xl p-4 hover:border-blue-500/50 transition group">
        <div class="flex items-center gap-3">
            <div class="p-2 bg-purple-500/10 text-purple-400 rounded-lg group-hover:bg-purple-500/20 transition">
                <i data-lucide="trending-up" class="w-5 h-5"></i>
            </div>
            <div class="flex-1">
                <h4 class="text-sm font-semibold text-white">Performance Monitoring</h4>
                <p class="text-xs text-gray-400">Monitor performa Polda/Polres/Polsek</p>
            </div>
            <i data-lucide="chevron-right" class="w-4 h-4 text-gray-400 group-hover:text-blue-400 transition"></i>
        </div>
    </a>
    <a href="{{ route('notifications.index') }}" class="bg-surface border border-border rounded-xl p-4 hover:border-blue-500/50 transition group">
        <div class="flex items-center gap-3">
            <div class="p-2 bg-yellow-500/10 text-yellow-400 rounded-lg group-hover:bg-yellow-500/20 transition">
                <i data-lucide="bell" class="w-5 h-5"></i>
            </div>
            <div class="flex-1">
                <h4 class="text-sm font-semibold text-white">Notifikasi & Automation</h4>
                <p class="text-xs text-gray-400">Kelola rules & notifikasi</p>
            </div>
            <i data-lucide="chevron-right" class="w-4 h-4 text-gray-400 group-hover:text-blue-400 transition"></i>
        </div>
    </a>
    <a href="{{ route('broadcasts.index') }}" class="bg-surface border border-border rounded-xl p-4 hover:border-red-500/50 transition group">
        <div class="flex items-center gap-3">
            <div class="p-2 bg-red-500/10 text-red-400 rounded-lg group-hover:bg-red-500/20 transition">
                <i data-lucide="megaphone" class="w-5 h-5"></i>
            </div>
            <div class="flex-1">
                <h4 class="text-sm font-semibold text-white">Broadcast Alert</h4>
                <p class="text-xs text-gray-400">Kirim peringatan darurat</p>
            </div>
            <i data-lucide="chevron-right" class="w-4 h-4 text-gray-400 group-hover:text-red-400 transition"></i>
        </div>
    </a>
    <a href="{{ route('analytics.index') }}" class="bg-surface border border-border rounded-xl p-4 hover:border-green-500/50 transition group">
        <div class="flex items-center gap-3">
            <div class="p-2 bg-green-500/10 text-green-400 rounded-lg group-hover:bg-green-500/20 transition">
                <i data-lucide="bar-chart-3" class="w-5 h-5"></i>
            </div>
            <div class="flex-1">
                <h4 class="text-sm font-semibold text-white">Analytics & Heatmap</h4>
                <p class="text-xs text-gray-400">Analisis & prediksi kriminal</p>
            </div>
            <i data-lucide="chevron-right" class="w-4 h-4 text-gray-400 group-hover:text-green-400 transition"></i>
        </div>
    </a>
</div>

<!-- Real-time Statistics Widget -->
<div class="bg-surface border border-border rounded-2xl p-6 mb-6">
    <div class="flex justify-between items-center mb-4">
        <h3 class="text-lg font-semibold text-white">Statistik Real-time</h3>
        <div class="flex gap-2">
            <button onclick="loadRealTimeStats('minute', this)" class="px-3 py-1 text-xs rounded-lg bg-white/5 text-gray-400 border border-white/10 hover:bg-white/10 transition">
                Per Menit
            </button>
            <button onclick="loadRealTimeStats('hour', this)" class="px-3 py-1 text-xs rounded-lg bg-blue-500/20 text-blue-400 border border-blue-500/30 hover:bg-blue-500/30 transition">
                Per Jam
            </button>
            <button onclick="loadRealTimeStats('day', this)" class="px-3 py-1 text-xs rounded-lg bg-white/5 text-gray-400 border border-white/10 hover:bg-white/10 transition">
                Per Hari
            </button>
        </div>
    </div>
    <div id="realtimeStatsChart" style="height: 200px;">
        <canvas id="realtimeChart"></canvas>
    </div>
</div>

<!-- Dispatch table -->
<div class="bg-surface border border-border rounded-2xl overflow-hidden">
    <div class="px-5 py-4 border-b border-border flex justify-between items-center">
        <h3 class="text-sm font-semibold text-white">Status Dispatch & Koordinasi</h3>
        <a href="{{ route('dispatches.index') }}" class="text-xs text-indigo-400 hover:text-indigo-300 transition">Lihat semua →</a>
    </div>
    <div class="overflow-x-auto">
        <table class="min-w-full text-left text-xs">
            <thead class="bg-white/5 text-gray-400 uppercase">
                <tr>
                    <th class="px-5 py-3 font-medium">Ticket</th>
                    <th class="px-5 py-3 font-medium">Lokasi</th>
                    <th class="px-5 py-3 font-medium">Kategori</th>
                    <th class="px-5 py-3 font-medium">Unit</th>
                    <th class="px-5 py-3 font-medium">Status</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-white/5 text-gray-300">
                @foreach($recentComplaints->take(3) as $complaint)
                    <tr class="hover:bg-white/5 transition">
                        <td class="px-5 py-3 font-mono text-gray-400 text-[11px]">{{ $complaint->ticket_number }}</td>
                        <td class="px-5 py-3">{{ $complaint->location->address ?? '-' }}</td>
                        <td class="px-5 py-3 flex items-center gap-2">
                            <span class="w-2 h-2 rounded-full bg-red-500"></span>
                            {{ ucfirst(str_replace('_', ' ', $complaint->category)) }}
                        </td>
                        <td class="px-5 py-3 text-gray-400">{{ $complaint->dispatches->first()->unit_type ?? '-' }}</td>
                        <td class="px-5 py-3">
                            <span class="px-2 py-1 rounded-full text-[10px] border border-white/10 bg-white/5">
                                {{ ucfirst($complaint->status) }}
                            </span>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

<!-- Additional Features Grid -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 mt-6">
    <!-- Coordinations -->
    <a href="{{ route('coordinations.index') }}" class="bg-surface border border-border rounded-2xl p-6 hover:border-green-500/50 transition group">
        <div class="flex items-center gap-4 mb-4">
            <div class="p-3 bg-green-500/10 text-green-400 rounded-xl group-hover:bg-green-500/20 transition">
                <i data-lucide="users" class="w-6 h-6"></i>
            </div>
            <div>
                <h3 class="text-lg font-semibold text-white">Koordinasi</h3>
                <p class="text-xs text-gray-400">Internal & Eksternal</p>
            </div>
        </div>
        <p class="text-sm text-gray-300">Kelola komunikasi antar instansi dan unit</p>
    </a>

    <!-- Field Reports -->
    <a href="{{ route('field-reports.index') }}" class="bg-surface border border-border rounded-2xl p-6 hover:border-blue-500/50 transition group">
        <div class="flex items-center gap-4 mb-4">
            <div class="p-3 bg-blue-500/10 text-blue-400 rounded-xl group-hover:bg-blue-500/20 transition">
                <i data-lucide="file-text" class="w-6 h-6"></i>
            </div>
            <div>
                <h3 class="text-lg font-semibold text-white">Laporan Lapangan</h3>
                <p class="text-xs text-gray-400">Dari Petugas</p>
            </div>
        </div>
        <p class="text-sm text-gray-300">Lihat laporan dan dokumentasi dari petugas lapangan</p>
    </a>

    <!-- Knowledge Center -->
    <a href="{{ route('knowledge-center.index') }}" class="bg-surface border border-border rounded-2xl p-6 hover:border-purple-500/50 transition group">
        <div class="flex items-center gap-4 mb-4">
            <div class="p-3 bg-purple-500/10 text-purple-400 rounded-xl group-hover:bg-purple-500/20 transition">
                <i data-lucide="book-open" class="w-6 h-6"></i>
            </div>
            <div>
                <h3 class="text-lg font-semibold text-white">Knowledge Center</h3>
                <p class="text-xs text-gray-400">Edukasi & Panduan</p>
            </div>
        </div>
        <p class="text-sm text-gray-300">Akses panduan keselamatan dan edukasi</p>
    </a>
</div>
@endsection

@push('scripts')
<script>
    if (document.getElementById('map')) {
        var map = L.map('map', {zoomControl: false}).setView([-6.2000, 106.8167], 11);
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {attribution: '&copy; OpenStreetMap'}).addTo(map);
        var iconMap = {
            'flame': L.divIcon({
                className: 'map-icon map-icon--critical',
                html: '<div class="map-marker map-marker--critical"><i data-lucide="flame"></i></div>',
                iconSize: [36, 36],
                iconAnchor: [18, 18]
            }),
            'bell-ring': L.divIcon({
                className: 'map-icon map-icon--warning',
                html: '<div class="map-marker map-marker--warning"><i data-lucide="bell-ring"></i></div>',
                iconSize: [32, 32],
                iconAnchor: [16, 16]
            }),
            'car': L.divIcon({
                className: 'map-icon map-icon--info',
                html: '<div class="map-marker map-marker--info"><i data-lucide="car"></i></div>',
                iconSize: [32, 32],
                iconAnchor: [16, 16]
            })
        };
        @foreach($heatmapData ?? [] as $point)
            var iconKey = '{{ $point['icon'] }}';
            var marker = L.marker([{{ $point['lat'] }}, {{ $point['lng'] }}], {
                icon: iconMap[iconKey] || iconMap['car']
            }).addTo(map).bindPopup(`
                <div class="space-y-1">
                    <p class="font-semibold text-sm text-white">{{ $point['label'] }}</p>
                    <p class="text-xs text-gray-400">{{ $point['description'] }}</p>
                    <span class="inline-flex items-center text-[10px] px-2 py-1 rounded-full bg-white/5 border border-white/10 text-gray-300">{{ $point['status'] }}</span>
                </div>
            `);
            marker.on('popupopen', function () {
                if (window.lucide) {
                    lucide.createIcons();
                }
            });
        @endforeach

        if (window.lucide) {
            lucide.createIcons();
        }
    }

    // Initialize Lucide icons after page load
    if (window.lucide) {
        lucide.createIcons();
    } else {
        // Wait for lucide to load
        window.addEventListener('load', function() {
            if (window.lucide) {
                lucide.createIcons();
            }
        });
    }

    document.querySelectorAll('.js-alert-card').forEach(function(card) {
        card.addEventListener('click', function () {
            const label = this.dataset.alert;
            const location = this.dataset.location;
            alert(`${label}\nLokasi: ${location}`);
        });
    });

    // Real-time Statistics Chart
    let realtimeChart = null;
    let currentPeriod = 'hour';

    function loadRealTimeStats(period, buttonElement = null) {
        currentPeriod = period;
        
        // Update button states
        document.querySelectorAll('[onclick^="loadRealTimeStats"]').forEach(btn => {
            btn.classList.remove('bg-blue-500/20', 'text-blue-400', 'border-blue-500/30');
            btn.classList.add('bg-white/5', 'text-gray-400', 'border-white/10');
        });
        
        if (buttonElement) {
            buttonElement.classList.remove('bg-white/5', 'text-gray-400', 'border-white/10');
            buttonElement.classList.add('bg-blue-500/20', 'text-blue-400', 'border-blue-500/30');
        }

        fetch(`{{ route('dashboard.realtime') }}?period=${period}`)
            .then(response => response.json())
            .then(data => {
                updateRealtimeChart(data);
            })
            .catch(error => {
                console.error('Error loading real-time stats:', error);
            });
    }

    function updateRealtimeChart(data) {
        const ctx = document.getElementById('realtimeChart');
        if (!ctx) return;

        const labels = Object.keys(data.data || {});
        const values = Object.values(data.data || {});

        if (realtimeChart) {
            realtimeChart.destroy();
        }

        realtimeChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: labels,
                datasets: [{
                    label: 'Jumlah Aduan',
                    data: values,
                    borderColor: 'rgb(59, 130, 246)',
                    backgroundColor: 'rgba(59, 130, 246, 0.1)',
                    tension: 0.4,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        labels: { color: '#9ca3af' }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: { color: '#9ca3af' },
                        grid: { color: 'rgba(255,255,255,0.1)' }
                    },
                    x: {
                        ticks: { color: '#9ca3af' },
                        grid: { color: 'rgba(255,255,255,0.1)' }
                    }
                }
            }
        });
    }

    // Load Chart.js and initialize
    function initRealtimeChart() {
        if (typeof Chart !== 'undefined') {
            loadRealTimeStats('hour');
            
            // Auto-refresh every 30 seconds
            setInterval(() => {
                loadRealTimeStats(currentPeriod);
            }, 30000);
        } else {
            // Load Chart.js if not already loaded
            const script = document.createElement('script');
            script.src = 'https://cdn.jsdelivr.net/npm/chart.js@latest';
            script.onload = () => {
                loadRealTimeStats('hour');
                setInterval(() => {
                    loadRealTimeStats(currentPeriod);
                }, 30000);
            };
            document.head.appendChild(script);
        }
    }

    // Initialize when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initRealtimeChart);
    } else {
        initRealtimeChart();
    }
</script>
<script src="https://cdn.jsdelivr.net/npm/chart.js@latest"></script>
@endpush