@extends('layouts.app')

@section('title', 'Dashboard Nasional')

@section('content')

<div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-600 text-sm font-medium">Total Aduan</h3>
                    <p class="text-3xl font-bold text-gray-900 mt-2">{{ $stats['total_complaints'] }}</p>
                </div>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-600 text-sm font-medium">Aduan Hari Ini</h3>
                    <p class="text-3xl font-bold text-blue-600 mt-2">{{ $stats['today_complaints'] }}</p>
                </div>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-600 text-sm font-medium">Aduan Jam Ini</h3>
                    <p class="text-3xl font-bold text-green-600 mt-2">{{ $stats['this_hour_complaints'] }}</p>
                </div>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-600 text-sm font-medium">Pending</h3>
                    <p class="text-3xl font-bold text-yellow-600 mt-2">{{ $stats['pending_complaints'] }}</p>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-600 text-sm font-medium">Sedang Diproses</h3>
                    <p class="text-3xl font-bold text-orange-600 mt-2">{{ $stats['processing_complaints'] }}</p>
                </div>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-600 text-sm font-medium">Selesai</h3>
                    <p class="text-3xl font-bold text-green-600 mt-2">{{ $stats['completed_complaints'] }}</p>
                </div>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-600 text-sm font-medium">CCTV Aktif</h3>
                    <p class="text-3xl font-bold text-purple-600 mt-2">{{ $stats['active_cctvs'] }}</p>
                </div>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-600 text-sm font-medium">Petugas Aktif</h3>
                    <p class="text-3xl font-bold text-indigo-600 mt-2">{{ $stats['active_officers'] }}</p>
                </div>
            </div>

            <!-- Map -->
            <div class="bg-white rounded-lg shadow p-6 mb-6">
                <h2 class="text-xl font-bold mb-4">Peta Nasional Real-time</h2>
                <div id="map" style="height: 500px; width: 100%;"></div>
            </div>

            <!-- Recent Complaints -->
            <div class="bg-white rounded-lg shadow p-6">
                <h2 class="text-xl font-bold mb-4">Aduan Terbaru</h2>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ticket</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Sumber</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Kategori</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Waktu</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($recentComplaints as $complaint)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">{{ $complaint->ticket_number }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">{{ ucfirst($complaint->source) }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <span class="px-2 py-1 text-xs rounded-full bg-blue-100 text-blue-800">
                                        {{ ucfirst(str_replace('_', ' ', $complaint->category)) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <span class="px-2 py-1 text-xs rounded-full bg-yellow-100 text-yellow-800">
                                        {{ ucfirst($complaint->status) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $complaint->created_at->format('d/m/Y H:i') }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm">
                                    <a href="{{ route('complaints.show', $complaint) }}" class="text-blue-600 hover:text-blue-900">Detail</a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
</div>
@endsection

@push('scripts')

    <script>
        // Initialize map
        var map = L.map('map').setView([-2.5489, 118.0149], 5); // Center of Indonesia

        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap contributors'
        }).addTo(map);

        // Add heatmap markers
        @foreach($heatmapData as $point)
        L.marker([{{ $point['lat'] }}, {{ $point['lng'] }}])
            .addTo(map)
            .bindPopup('Aduan: {{ $point['count'] }}<br>Kategori: {{ $point['category'] }}');
        @endforeach
    </script>
@endpush

