@extends('layouts.app')

@section('title', 'Daftar Dispatch')

@section('content')
<div>
    <h2 class="text-3xl font-bold mb-6">Daftar Dispatch</h2>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">ID</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ticket</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Polsek</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Waktu</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Aksi</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($dispatches as $dispatch)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $dispatch->id }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $dispatch->complaint->ticket_number }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ ucfirst($dispatch->unit_type) }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $dispatch->polsek->name }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 py-1 text-xs rounded-full 
                            {{ $dispatch->status == 'completed' ? 'bg-green-100 text-green-800' : '' }}
                            {{ $dispatch->status == 'pending' ? 'bg-yellow-100 text-yellow-800' : '' }}
                            {{ $dispatch->status == 'accepted' ? 'bg-blue-100 text-blue-800' : '' }}">
                            {{ ucfirst($dispatch->status) }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $dispatch->created_at->format('d/m/Y H:i') }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <a href="{{ route('dispatches.show', $dispatch) }}" class="text-blue-600 hover:text-blue-900">Detail</a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="px-6 py-4 text-center text-gray-500">Tidak ada data dispatch</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $dispatches->links() }}
    </div>
</div>
@endsection

