@extends('layouts.app')

@section('title', 'Detail Dispatch')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold">Detail Dispatch #{{ $dispatch->id }}</h2>
        <a href="{{ route('dispatches.index') }}" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            ← Kembali
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Informasi Dispatch</h3>
            <dl class="space-y-2">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Unit Type</dt>
                    <dd class="text-sm text-gray-900">{{ ucfirst($dispatch->unit_type) }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Status</dt>
                    <dd class="text-sm">
                        <span class="px-2 py-1 text-xs rounded-full bg-blue-100 text-blue-800">
                            {{ ucfirst($dispatch->status) }}
                        </span>
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Polsek</dt>
                    <dd class="text-sm text-gray-900">{{ $dispatch->polsek->name }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Instructions</dt>
                    <dd class="text-sm text-gray-900">{{ $dispatch->instructions ?? '-' }}</dd>
                </div>
            </dl>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Complaint</h3>
            <p class="text-sm text-gray-900">{{ $dispatch->complaint->description }}</p>
            <a href="{{ route('complaints.show', $dispatch->complaint) }}" class="text-blue-600 hover:text-blue-900 text-sm mt-2 inline-block">
                Lihat Detail Aduan →
            </a>
        </div>
    </div>

    @if($dispatch->dispatchUnits->count() > 0)
    <div class="bg-white rounded-lg shadow p-6 mt-6">
        <h3 class="text-xl font-bold mb-4">Unit yang Ditugaskan</h3>
        <div class="space-y-4">
            @foreach($dispatch->dispatchUnits as $unit)
            <div class="border-b pb-4 last:border-0">
                <p class="font-medium">{{ $unit->officer->user->name }}</p>
                <p class="text-sm text-gray-600">NIP: {{ $unit->officer->nip }}</p>
                <p class="text-sm text-gray-600">Status: {{ ucfirst($unit->status) }}</p>
            </div>
            @endforeach
        </div>
    </div>
    @endif
</div>
@endsection
