@extends('layouts.app')

@section('title', 'Detail Laporan Lapangan')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold">Laporan Lapangan #{{ $fieldReport->id }}</h2>
        <a href="{{ route('field-reports.index') }}" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            ← Kembali
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Informasi Laporan</h3>
            <dl class="space-y-2">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Petugas</dt>
                    <dd class="text-sm text-gray-900">{{ $fieldReport->officer->user->name }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Unit</dt>
                    <dd class="text-sm text-gray-900">{{ ucfirst($fieldReport->officer->unit_type) }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Dispatch</dt>
                    <dd class="text-sm text-gray-900">#{{ $fieldReport->dispatch_id }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Status</dt>
                    <dd class="text-sm">
                        <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">
                            {{ ucfirst($fieldReport->status) }}
                        </span>
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Deskripsi</dt>
                    <dd class="text-sm text-gray-900">{{ $fieldReport->description ?? '-' }}</dd>
                </div>
            </dl>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Lokasi Petugas</h3>
            @if($fieldReport->latitude && $fieldReport->longitude)
                <p class="text-sm text-gray-900 mb-2">Koordinat: {{ $fieldReport->latitude }}, {{ $fieldReport->longitude }}</p>
                <div id="map" style="height: 300px; width: 100%;"></div>
            @else
                <p class="text-sm text-gray-500">Lokasi tidak tersedia</p>
            @endif
        </div>
    </div>

    @if($fieldReport->photos)
    <div class="bg-white rounded-lg shadow p-6 mt-6">
        <h3 class="text-xl font-bold mb-4">Foto TKP</h3>
        <div class="grid grid-cols-4 gap-4">
            @foreach($fieldReport->photos as $photo)
            <img src="{{ Storage::url($photo) }}" alt="Foto" class="w-full h-32 object-cover rounded">
            @endforeach
        </div>
    </div>
    @endif

    @if($fieldReport->videos)
    <div class="bg-white rounded-lg shadow p-6 mt-6">
        <h3 class="text-xl font-bold mb-4">Video TKP</h3>
        <div class="grid grid-cols-2 gap-4">
            @foreach($fieldReport->videos as $video)
            <video controls class="w-full rounded">
                <source src="{{ Storage::url($video) }}" type="video/mp4">
            </video>
            @endforeach
        </div>
    </div>
    @endif
</div>
@endsection

@push('scripts')
@if($fieldReport->latitude && $fieldReport->longitude)
<script>
    var map = L.map('map').setView([{{ $fieldReport->latitude }}, {{ $fieldReport->longitude }}], 15);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png').addTo(map);
    L.marker([{{ $fieldReport->latitude }}, {{ $fieldReport->longitude }}]).addTo(map);
</script>
@endif
@endpush