@extends('layouts.app')

@section('title', 'Knowledge Center')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold">Knowledge Center</h2>
        @if(auth()->user()->role === 'admin')
            <a href="{{ route('knowledge-center.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                + Tambah Artikel
            </a>
        @endif
    </div>

    <form method="GET" class="mb-6 flex gap-4">
        <select name="category" class="border rounded px-3 py-2">
            <option value="">Semua Kategori</option>
            <option value="safety_guide" {{ request('category') == 'safety_guide' ? 'selected' : '' }}>Safety Guide</option>
            <option value="digital_safety" {{ request('category') == 'digital_safety' ? 'selected' : '' }}>Digital Safety</option>
            <option value="emergency_procedure" {{ request('category') == 'emergency_procedure' ? 'selected' : '' }}>Emergency Procedure</option>
            <option value="training" {{ request('category') == 'training' ? 'selected' : '' }}>Training</option>
            <option value="security_article" {{ request('category') == 'security_article' ? 'selected' : '' }}>Security Article</option>
        </select>
        <input type="text" name="search" class="border rounded px-3 py-2 flex-1" placeholder="Cari artikel..." value="{{ request('search') }}">
        <button type="submit" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            Cari
        </button>
    </form>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        @forelse($articles as $article)
        <div class="bg-white rounded-lg shadow overflow-hidden">
            <div class="p-6">
                <div class="flex items-center justify-between text-sm text-gray-500 mb-2">
                    <span class="px-2 py-1 text-xs rounded-full bg-blue-100 text-blue-800">
                        {{ ucfirst(str_replace('_', ' ', $article->category)) }}
                    </span>
                    <span>{{ $article->created_at->format('d M Y') }}</span>
                </div>
                <h3 class="text-xl font-bold mb-2">{{ $article->title }}</h3>
                <p class="text-gray-600 mb-4">{{ $article->excerpt }}</p>
                <a href="{{ route('knowledge-center.show', $article) }}" class="text-blue-600 hover:text-blue-900">
                    Baca selengkapnya →
                </a>
            </div>
        </div>
        @empty
        <p class="text-gray-500">Belum ada artikel</p>
        @endforelse
    </div>

    <div class="mt-6">
        {{ $articles->links() }}
    </div>
</div>
@endsection

