@extends('layouts.app')

@section('title', $knowledgeCenter->title)

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <p class="text-sm text-gray-500 mb-1">
                {{ ucfirst(str_replace('_', ' ', $knowledgeCenter->category)) }} • {{ $knowledgeCenter->created_at->format('d M Y') }}
            </p>
            <h2 class="text-3xl font-bold">{{ $knowledgeCenter->title }}</h2>
        </div>
        <a href="{{ route('knowledge-center.index') }}" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            ← Kembali
        </a>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <article class="prose max-w-none">
            {!! nl2br(e($knowledgeCenter->content)) !!}
        </article>
    </div>
</div>
@endsection

