@extends('layouts.app')

@section('title', 'Tambah Notification Template')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-3xl font-bold text-white">Tambah Notification Template</h2>
            <p class="text-gray-400 text-sm mt-1">Buat template notifikasi baru</p>
        </div>
        <a href="{{ route('notification-templates.index') }}" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-4 py-2 rounded-lg text-sm transition">
            ← Kembali
        </a>
    </div>

    <form action="{{ route('notification-templates.store') }}" method="POST" class="bg-surface border border-border rounded-xl p-6">
        @csrf

        <div class="space-y-6">
            <!-- Basic Info -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Nama Template *</label>
                <input type="text" name="name" value="{{ old('name') }}" required
                       class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500"
                       placeholder="dispatch_new">
                @error('name')
                <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Type -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Tipe *</label>
                <select name="type" required
                        class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Pilih Tipe</option>
                    <option value="sms" {{ old('type') == 'sms' ? 'selected' : '' }}>SMS</option>
                    <option value="whatsapp" {{ old('type') == 'whatsapp' ? 'selected' : '' }}>WhatsApp</option>
                    <option value="email" {{ old('type') == 'email' ? 'selected' : '' }}>Email</option>
                    <option value="push" {{ old('type') == 'push' ? 'selected' : '' }}>Push Notification</option>
                </select>
                @error('type')
                <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Subject (for email/push) -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Subject (Optional, untuk Email/Push)</label>
                <input type="text" name="subject" value="{{ old('subject') }}"
                       class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500"
                       placeholder="Tugas Baru">
            </div>

            <!-- Body -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Body *</label>
                <textarea name="body" rows="8" required
                          class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500 font-mono text-sm"
                          placeholder="Tugas baru: {{{description}}}. Lokasi: {{{location}}}">{{ old('body') }}</textarea>
                <p class="text-gray-500 text-xs mt-1">Gunakan {{{variable}}} untuk variable substitution</p>
                @error('body')
                <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Variables -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Variables (JSON Array, Optional)</label>
                <textarea name="variables" rows="3"
                          class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 font-mono text-sm text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500"
                          placeholder='["description", "location", "ticket_number"]'>{{ old('variables', '[]') }}</textarea>
                <p class="text-gray-500 text-xs mt-1">Daftar variable yang tersedia dalam template</p>
            </div>

            <!-- Status -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Status</label>
                <select name="is_active"
                        class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="1" {{ old('is_active', true) ? 'selected' : '' }}>Aktif</option>
                    <option value="0" {{ !old('is_active', true) ? 'selected' : '' }}>Nonaktif</option>
                </select>
            </div>

            <!-- Submit -->
            <div class="flex gap-3 pt-4">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition">
                    Simpan Template
                </button>
                <a href="{{ route('notification-templates.index') }}" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-6 py-2 rounded-lg transition">
                    Batal
                </a>
            </div>
        </div>
    </form>
</div>
@endsection

