@extends('layouts.app')

@section('title', 'Edit Notification Template')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-3xl font-bold text-white">Edit Notification Template</h2>
            <p class="text-gray-400 text-sm mt-1">Edit template notifikasi</p>
        </div>
        <a href="{{ route('notification-templates.index') }}" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-4 py-2 rounded-lg text-sm transition">
            ← Kembali
        </a>
    </div>

    <form action="{{ route('notification-templates.update', $notificationTemplate) }}" method="POST" class="bg-surface border border-border rounded-xl p-6">
        @csrf
        @method('PUT')

        <div class="space-y-6">
            <!-- Basic Info -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Nama Template *</label>
                <input type="text" name="name" value="{{ old('name', $notificationTemplate->name) }}" required
                       class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">
                @error('name')
                <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Type -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Tipe *</label>
                <select name="type" required
                        class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Pilih Tipe</option>
                    <option value="sms" {{ old('type', $notificationTemplate->type) == 'sms' ? 'selected' : '' }}>SMS</option>
                    <option value="whatsapp" {{ old('type', $notificationTemplate->type) == 'whatsapp' ? 'selected' : '' }}>WhatsApp</option>
                    <option value="email" {{ old('type', $notificationTemplate->type) == 'email' ? 'selected' : '' }}>Email</option>
                    <option value="push" {{ old('type', $notificationTemplate->type) == 'push' ? 'selected' : '' }}>Push Notification</option>
                </select>
                @error('type')
                <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Subject -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Subject (Optional)</label>
                <input type="text" name="subject" value="{{ old('subject', $notificationTemplate->subject) }}"
                       class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            <!-- Body -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Body *</label>
                <textarea name="body" rows="8" required
                          class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500 font-mono text-sm">{{ old('body', $notificationTemplate->body) }}</textarea>
                @error('body')
                <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Variables -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Variables (JSON Array)</label>
                <textarea name="variables" rows="3"
                          class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 font-mono text-sm text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('variables', json_encode($notificationTemplate->variables ?? [], JSON_PRETTY_PRINT)) }}</textarea>
            </div>

            <!-- Status -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Status</label>
                <select name="is_active"
                        class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="1" {{ old('is_active', $notificationTemplate->is_active) ? 'selected' : '' }}>Aktif</option>
                    <option value="0" {{ !old('is_active', $notificationTemplate->is_active) ? 'selected' : '' }}>Nonaktif</option>
                </select>
            </div>

            <!-- Submit -->
            <div class="flex gap-3 pt-4">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition">
                    Update Template
                </button>
                <a href="{{ route('notification-templates.index') }}" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-6 py-2 rounded-lg transition">
                    Batal
                </a>
            </div>
        </div>
    </form>
</div>
@endsection

