@extends('layouts.app')

@section('title', 'Notification Template Detail')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-3xl font-bold text-white">{{ $notificationTemplate->name }}</h2>
            <p class="text-gray-400 text-sm mt-1">Detail notification template</p>
        </div>
        <div class="flex gap-2">
            <a href="{{ route('notification-templates.edit', $notificationTemplate) }}" 
               class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm transition">
                Edit
            </a>
            <a href="{{ route('notification-templates.index') }}" 
               class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-4 py-2 rounded-lg text-sm transition">
                ← Kembali
            </a>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Info -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Basic Information -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Informasi Template</h3>
                <div class="space-y-4">
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Nama</span>
                        <span class="text-white">{{ $notificationTemplate->name }}</span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Tipe</span>
                        <span class="px-3 py-1 bg-blue-500/20 text-blue-400 text-sm rounded-full border border-blue-500/30">
                            {{ strtoupper($notificationTemplate->type) }}
                        </span>
                    </div>
                    @if($notificationTemplate->subject)
                    <div class="flex justify-between items-start py-2 border-b border-white/5">
                        <span class="text-gray-400">Subject</span>
                        <span class="text-white text-right">{{ $notificationTemplate->subject }}</span>
                    </div>
                    @endif
                    <div class="flex justify-between items-center py-2 border-b border-white/5">
                        <span class="text-gray-400">Status</span>
                        @if($notificationTemplate->is_active)
                        <span class="px-3 py-1 bg-green-500/20 text-green-400 text-sm rounded-full border border-green-500/30">
                            Aktif
                        </span>
                        @else
                        <span class="px-3 py-1 bg-gray-500/20 text-gray-400 text-sm rounded-full border border-gray-500/30">
                            Nonaktif
                        </span>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Body -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Body Template</h3>
                <div class="bg-white/5 rounded-lg p-4">
                    <pre class="text-gray-300 font-mono text-sm whitespace-pre-wrap">{{ $notificationTemplate->body }}</pre>
                </div>
            </div>

            <!-- Variables -->
            @if($notificationTemplate->variables)
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Variables</h3>
                <div class="flex flex-wrap gap-2">
                    @foreach($notificationTemplate->variables as $var)
                    <span class="px-3 py-1 bg-purple-500/20 text-purple-400 text-sm rounded border border-purple-500/30">
                        {{{{ $var }}}}
                    </span>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Preview -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Preview</h3>
                <div class="bg-white/5 rounded-lg p-4">
                    @php
                        $previewVars = [];
                        foreach($notificationTemplate->variables ?? [] as $var) {
                            $previewVars[$var] = '[' . $var . ']';
                        }
                        $preview = $notificationTemplate->render($previewVars);
                    @endphp
                    @if($notificationTemplate->subject)
                    <p class="text-white font-semibold mb-2">{{ $preview['subject'] }}</p>
                    @endif
                    <p class="text-gray-300 whitespace-pre-wrap">{{ $preview['body'] }}</p>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Metadata -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Metadata</h3>
                <div class="space-y-4">
                    <div>
                        <p class="text-gray-400 text-sm">Created</p>
                        <p class="text-white text-sm">{{ $notificationTemplate->created_at->format('d/m/Y H:i') }}</p>
                    </div>
                    <div>
                        <p class="text-gray-400 text-sm">Updated</p>
                        <p class="text-white text-sm">{{ $notificationTemplate->updated_at->format('d/m/Y H:i') }}</p>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="bg-surface border border-border rounded-xl p-6">
                <h3 class="text-lg font-semibold text-white mb-4">Actions</h3>
                <div class="space-y-2">
                    <a href="{{ route('notification-templates.edit', $notificationTemplate) }}" 
                       class="block w-full bg-blue-600 hover:bg-blue-700 text-white text-center px-4 py-2 rounded-lg text-sm transition">
                        Edit Template
                    </a>
                    <form action="{{ route('notification-templates.destroy', $notificationTemplate) }}" method="POST" 
                          onsubmit="return confirm('Yakin ingin menghapus template ini?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" 
                                class="block w-full bg-red-600 hover:bg-red-700 text-white text-center px-4 py-2 rounded-lg text-sm transition">
                            Hapus Template
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

