@extends('layouts.app')

@section('title', 'Notification & Automation Management')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="mb-6">
        <h1 class="text-3xl font-bold text-white mb-2">Notification & Automation</h1>
        <p class="text-gray-400">Kelola notifikasi dan aturan automasi sistem</p>
    </div>

    <!-- Automation Rules -->
    <div class="bg-surface border border-border rounded-xl p-6 mb-6">
        <div class="flex justify-between items-center mb-4">
            <h2 class="text-xl font-semibold text-white">Automation Rules</h2>
            <button class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm">
                + Tambah Rule
            </button>
        </div>
        <div class="space-y-4">
            @forelse($automationRules as $rule)
            <div class="bg-white/5 border border-white/10 rounded-lg p-4">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <div class="flex items-center gap-2 mb-2">
                            <h3 class="text-white font-semibold">{{ $rule['name'] }}</h3>
                            @if($rule['is_active'])
                            <span class="px-2 py-1 bg-green-500/20 text-green-400 text-xs rounded-full border border-green-500/30">
                                Aktif
                            </span>
                            @else
                            <span class="px-2 py-1 bg-gray-500/20 text-gray-400 text-xs rounded-full border border-gray-500/30">
                                Nonaktif
                            </span>
                            @endif
                        </div>
                        <p class="text-gray-400 text-sm mb-2">{{ $rule['description'] }}</p>
                        <div class="flex flex-wrap gap-2 text-xs">
                            <span class="text-gray-500">Trigger:</span>
                            <span class="text-blue-400">{{ $rule['trigger'] }}</span>
                            <span class="text-gray-500 ml-2">Actions:</span>
                            @foreach($rule['actions'] as $action)
                            <span class="text-green-400">{{ $action }}</span>
                            @endforeach
                        </div>
                    </div>
                    <div class="flex gap-2">
                        <button class="text-blue-400 hover:text-blue-300 text-sm">Edit</button>
                        <button class="text-red-400 hover:text-red-300 text-sm">Hapus</button>
                    </div>
                </div>
            </div>
            @empty
            <div class="text-center text-gray-400 py-8">
                Tidak ada automation rules
            </div>
            @endforelse
        </div>
    </div>

    <!-- Recent Notifications -->
    <div class="bg-surface border border-border rounded-xl p-6">
        <h2 class="text-xl font-semibold text-white mb-4">Recent Notifications</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full">
                <thead class="bg-white/5">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Waktu</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Tipe</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Penerima</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Pesan</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Status</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    @forelse($notifications as $notification)
                    <tr class="hover:bg-white/5">
                        <td class="px-6 py-4 whitespace-nowrap text-gray-400 text-sm">
                            {{ $notification->created_at->format('d/m/Y H:i') }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 bg-blue-500/20 text-blue-400 text-xs rounded-full">
                                {{ ucfirst($notification->type ?? 'notification') }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-white text-sm">
                            {{ $notification->user->name ?? ($notification->sender->name ?? 'System') }}
                        </td>
                        <td class="px-6 py-4 text-gray-300 text-sm">
                            {{ \Illuminate\Support\Str::limit($notification->message ?? $notification->title ?? '-', 50) }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @if($notification->read_at)
                            <span class="text-green-400 text-xs">Read</span>
                            @else
                            <span class="text-yellow-400 text-xs">Unread</span>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-6 py-4 text-center text-gray-400">
                            Tidak ada notifikasi
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if(method_exists($notifications, 'links'))
        <div class="mt-4">
            {{ $notifications->links() }}
        </div>
        @endif
    </div>
</div>
@endsection

