@extends('layouts.app')

@section('title', 'Data Petugas')

@section('content')
<div>
    <h2 class="text-3xl font-bold mb-6">Data Petugas Lapangan</h2>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Nama</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">NIP</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Polsek</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Lokasi</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($officers as $officer)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">{{ $officer->user->name }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $officer->nip }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ ucfirst($officer->unit_type) }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">{{ $officer->polsek?->name ?? '-' }}</td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 py-1 text-xs rounded-full
                            {{ $officer->status === 'available' ? 'bg-green-100 text-green-800' : '' }}
                            {{ $officer->status === 'busy' ? 'bg-yellow-100 text-yellow-800' : '' }}">
                            {{ ucfirst(str_replace('_', ' ', $officer->status)) }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        @if($officer->current_latitude && $officer->current_longitude)
                            {{ $officer->current_latitude }}, {{ $officer->current_longitude }}
                        @else
                            -
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-gray-500">Tidak ada data petugas</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $officers->links() }}
    </div>
</div>
@endsection

