@extends('layouts.app')

@section('title', 'Detail Petugas')

@section('content')
<div>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold">Petugas: {{ $officer->user->name }}</h2>
        <a href="{{ route('officers.index') }}" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            ← Kembali
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Informasi Petugas</h3>
            <dl class="space-y-2">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Nama</dt>
                    <dd class="text-sm text-gray-900">{{ $officer->user->name }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">NIP</dt>
                    <dd class="text-sm text-gray-900">{{ $officer->nip }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Pangkat</dt>
                    <dd class="text-sm text-gray-900">{{ $officer->rank ?? '-' }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Unit</dt>
                    <dd class="text-sm text-gray-900">{{ $officer->unit ?? '-' }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Status</dt>
                    <dd class="text-sm">
                        <span class="px-2 py-1 text-xs rounded-full
                            {{ $officer->status === 'available' ? 'bg-green-100 text-green-800' : '' }}
                            {{ $officer->status === 'busy' ? 'bg-yellow-100 text-yellow-800' : '' }}">
                            {{ ucfirst(str_replace('_', ' ', $officer->status)) }}
                        </span>
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Kontak</dt>
                    <dd class="text-sm text-gray-900">{{ $officer->phone ?? '-' }}</dd>
                </div>
            </dl>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Lokasi Terakhir</h3>
            @if($officer->current_latitude && $officer->current_longitude)
                <p class="text-sm text-gray-900 mb-2">
                    {{ $officer->current_latitude }}, {{ $officer->current_longitude }}<br>
                    <span class="text-xs text-gray-500">Update: {{ optional($officer->last_location_update)->diffForHumans() }}</span>
                </p>
                <div id="map" style="height: 300px; width: 100%;"></div>
            @else
                <p class="text-sm text-gray-500">Lokasi tidak tersedia</p>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
@if($officer->current_latitude && $officer->current_longitude)
<script>
    var map = L.map('map').setView([{{ $officer->current_latitude }}, {{ $officer->current_longitude }}], 14);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png').addTo(map);
    L.marker([{{ $officer->current_latitude }}, {{ $officer->current_longitude }}]).addTo(map);
</script>
@endif
@endpush

