<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ComplaintController;
use App\Http\Controllers\DispatchController;
use App\Http\Controllers\PanicButtonController;
use App\Http\Controllers\OfficerController;
use App\Http\Controllers\CctvController;

/*
|--------------------------------------------------------------------------
| API Routes for Mobile App
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for mobile application.
| These routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Public API routes (no authentication required)
Route::post('/panic-buttons/{panicButton}/activate', [PanicButtonController::class, 'activate']);

// Protected API routes (require authentication)
Route::middleware('auth:sanctum')->group(function () {
    // User info
    Route::get('/user', function (Request $request) {
        return $request->user();
    });

    // Complaints
    Route::get('/complaints', [ComplaintController::class, 'index']);
    Route::post('/complaints', [ComplaintController::class, 'store']);
    Route::get('/complaints/{complaint}', [ComplaintController::class, 'show']);

    // Dispatches
    Route::get('/dispatches', [DispatchController::class, 'index']);
    Route::get('/dispatches/{dispatch}', [DispatchController::class, 'show']);
    Route::post('/dispatches/{dispatch}/accept', [DispatchController::class, 'accept']);
    Route::post('/dispatches/{dispatch}/complete', [DispatchController::class, 'complete']);

    // Officers
    Route::get('/officers', [OfficerController::class, 'index']);
    Route::post('/officers/{officer}/location', [OfficerController::class, 'updateLocation']);

    // CCTV
    Route::get('/cctvs/nearby', [CctvController::class, 'nearby']);
    Route::get('/cctvs/{cctv}/stream', [CctvController::class, 'stream']);

    // Panic Buttons
    Route::get('/panic-buttons', [PanicButtonController::class, 'index']);
});

