<?php

use App\Http\Controllers\AnalyticsController;
use App\Http\Controllers\AreaCodeController;
use App\Http\Controllers\AutomationRuleController;
use App\Http\Controllers\BroadcastController;
use App\Http\Controllers\CallRecordController;
use App\Http\Controllers\CctvController;
use App\Http\Controllers\ComplaintController;
use App\Http\Controllers\CoordinationController;
use App\Http\Controllers\DispatchController;
use App\Http\Controllers\FieldReportController;
use App\Http\Controllers\KnowledgeCenterController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\NotificationTemplateController;
use App\Http\Controllers\OfficerController;
use App\Http\Controllers\PanicButtonController;
use App\Http\Controllers\PerformanceController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

Route::get('/', [App\Http\Controllers\DashboardController::class, 'index'])->name('dashboard');
Route::get('/dashboard/stats/realtime', [App\Http\Controllers\DashboardController::class, 'getRealTimeStats'])->name('dashboard.realtime');

Route::resource('complaints', ComplaintController::class)->only(['index', 'show']);
Route::post('/complaints/{complaint}/classify', [ComplaintController::class, 'classify'])->name('complaints.classify');
Route::resource('dispatches', DispatchController::class)->only(['index', 'show']);
Route::resource('cctvs', CctvController::class)->only(['index', 'show']);
Route::post('/cctvs/{cctv}/snapshot', [CctvController::class, 'snapshot'])->name('cctvs.snapshot');
Route::resource('panic-buttons', PanicButtonController::class)->only(['index', 'show']);
Route::resource('officers', OfficerController::class)->only(['index', 'show']);
Route::resource('knowledge-center', KnowledgeCenterController::class)->only(['index', 'show']);
Route::get('/analytics', [AnalyticsController::class, 'index'])->name('analytics.index');
Route::get('/api/analytics/crime-prediction', [AnalyticsController::class, 'getCrimePrediction'])->name('analytics.crime-prediction');
Route::get('/performance', [PerformanceController::class, 'index'])->name('performance.index');
Route::get('/performance/{type}/{id}', [PerformanceController::class, 'show'])
    ->where(['type' => 'polda|polres|polsek', 'id' => '[0-9]+'])
    ->name('performance.show');
Route::resource('coordinations', CoordinationController::class)->only(['index']);
Route::post('/complaints/{complaint}/coordinations', [CoordinationController::class, 'store'])->name('coordinations.store');
Route::post('/coordinations/{coordination}/acknowledge', [CoordinationController::class, 'acknowledge'])->name('coordinations.acknowledge');
Route::resource('field-reports', FieldReportController::class)->only(['index', 'show']);
Route::get('/notifications', [NotificationController::class, 'index'])->name('notifications.index');
Route::get('/broadcasts', [BroadcastController::class, 'index'])->name('broadcasts.index');
Route::post('/broadcasts', [BroadcastController::class, 'store'])->name('broadcasts.store');

// Phone integration routes (webhook from IP-PBX)
Route::post('/api/phone/incoming', [App\Http\Controllers\PhoneController::class, 'incomingCall'])->name('phone.incoming');
Route::post('/api/phone/answered', [App\Http\Controllers\PhoneController::class, 'callAnswered'])->name('phone.answered');
Route::post('/api/phone/ended', [App\Http\Controllers\PhoneController::class, 'callEnded'])->name('phone.ended');
Route::post('/api/phone/complaint', [App\Http\Controllers\PhoneController::class, 'createComplaintFromCall'])->name('phone.complaint');

// New feature routes
Route::resource('call-records', CallRecordController::class)->only(['index', 'show']);
Route::resource('automation-rules', AutomationRuleController::class);
Route::resource('notification-templates', NotificationTemplateController::class);
Route::resource('area-codes', AreaCodeController::class);
Route::resource('geo-fences', App\Http\Controllers\GeoFenceController::class);

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
