

<?php $__env->startSection('title', 'Daftar Dispatch'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <h2 class="text-3xl font-bold mb-6">Daftar Dispatch</h2>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">ID</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ticket</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Polsek</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Waktu</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Aksi</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $dispatches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dispatch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e($dispatch->id); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e($dispatch->complaint->ticket_number); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e(ucfirst($dispatch->unit_type)); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e($dispatch->polsek->name); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 py-1 text-xs rounded-full 
                            <?php echo e($dispatch->status == 'completed' ? 'bg-green-100 text-green-800' : ''); ?>

                            <?php echo e($dispatch->status == 'pending' ? 'bg-yellow-100 text-yellow-800' : ''); ?>

                            <?php echo e($dispatch->status == 'accepted' ? 'bg-blue-100 text-blue-800' : ''); ?>">
                            <?php echo e(ucfirst($dispatch->status)); ?>

                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e($dispatch->created_at->format('d/m/Y H:i')); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <a href="<?php echo e(route('dispatches.show', $dispatch)); ?>" class="text-blue-600 hover:text-blue-900">Detail</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="px-6 py-4 text-center text-gray-500">Tidak ada data dispatch</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        <?php echo e($dispatches->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/kor.copilotproduction.com/resources/views/dispatches/index.blade.php ENDPATH**/ ?>