

<?php $__env->startSection('title', 'Notification Templates'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-3xl font-bold text-white">Notification Templates</h2>
            <p class="text-gray-400 text-sm mt-1">Kelola template notifikasi</p>
        </div>
        <a href="<?php echo e(route('notification-templates.create')); ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm transition flex items-center gap-2">
            <i data-lucide="plus" class="w-4 h-4"></i>
            Tambah Template
        </a>
    </div>

    <!-- Filters -->
    <div class="bg-surface border border-border rounded-xl p-4 mb-6">
        <form method="GET" action="<?php echo e(route('notification-templates.index')); ?>" class="flex gap-4 flex-wrap">
            <select name="type" class="bg-white/5 border border-white/10 rounded-lg px-3 py-2 text-sm text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">Semua Tipe</option>
                <option value="sms" <?php echo e(request('type') == 'sms' ? 'selected' : ''); ?>>SMS</option>
                <option value="whatsapp" <?php echo e(request('type') == 'whatsapp' ? 'selected' : ''); ?>>WhatsApp</option>
                <option value="email" <?php echo e(request('type') == 'email' ? 'selected' : ''); ?>>Email</option>
                <option value="push" <?php echo e(request('type') == 'push' ? 'selected' : ''); ?>>Push Notification</option>
            </select>
            <select name="is_active" class="bg-white/5 border border-white/10 rounded-lg px-3 py-2 text-sm text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">Semua Status</option>
                <option value="1" <?php echo e(request('is_active') == '1' ? 'selected' : ''); ?>>Aktif</option>
                <option value="0" <?php echo e(request('is_active') == '0' ? 'selected' : ''); ?>>Nonaktif</option>
            </select>
            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm transition">
                Filter
            </button>
            <a href="<?php echo e(route('notification-templates.index')); ?>" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-4 py-2 rounded-lg text-sm transition">
                Reset
            </a>
        </form>
    </div>

    <!-- Templates List -->
    <div class="space-y-4">
        <?php $__empty_1 = true; $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="bg-surface border border-border rounded-xl p-6 hover:border-blue-500/30 transition">
            <div class="flex justify-between items-start">
                <div class="flex-1">
                    <div class="flex items-center gap-3 mb-3">
                        <h3 class="text-lg font-semibold text-white"><?php echo e($template->name); ?></h3>
                        <span class="px-2 py-1 bg-blue-500/20 text-blue-400 text-xs rounded-full border border-blue-500/30">
                            <?php echo e(strtoupper($template->type)); ?>

                        </span>
                        <?php if($template->is_active): ?>
                        <span class="px-2 py-1 bg-green-500/20 text-green-400 text-xs rounded-full border border-green-500/30">
                            Aktif
                        </span>
                        <?php else: ?>
                        <span class="px-2 py-1 bg-gray-500/20 text-gray-400 text-xs rounded-full border border-gray-500/30">
                            Nonaktif
                        </span>
                        <?php endif; ?>
                    </div>
                    <?php if($template->subject): ?>
                    <div class="mb-3">
                        <p class="text-gray-500 text-sm mb-1">Subject</p>
                        <p class="text-white"><?php echo e($template->subject); ?></p>
                    </div>
                    <?php endif; ?>
                    <div class="mb-3">
                        <p class="text-gray-500 text-sm mb-1">Body</p>
                        <p class="text-gray-300 text-sm bg-white/5 p-3 rounded-lg font-mono whitespace-pre-wrap"><?php echo e(\Illuminate\Support\Str::limit($template->body, 200)); ?></p>
                    </div>
                    <?php if($template->variables): ?>
                    <div>
                        <p class="text-gray-500 text-sm mb-1">Variables</p>
                        <div class="flex flex-wrap gap-2">
                            <?php $__currentLoopData = $template->variables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $var): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="px-2 py-1 bg-purple-500/20 text-purple-400 text-xs rounded border border-purple-500/30">
                                <?php echo e({ $var); ?>}
                            </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="flex gap-2 ml-4">
                    <a href="<?php echo e(route('notification-templates.show', $template)); ?>" 
                       class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-3 py-2 rounded-lg text-sm transition">
                        <i data-lucide="eye" class="w-4 h-4"></i>
                    </a>
                    <a href="<?php echo e(route('notification-templates.edit', $template)); ?>" 
                       class="bg-blue-500/20 hover:bg-blue-500/30 border border-blue-500/30 text-blue-400 px-3 py-2 rounded-lg text-sm transition">
                        <i data-lucide="edit" class="w-4 h-4"></i>
                    </a>
                    <form action="<?php echo e(route('notification-templates.destroy', $template)); ?>" method="POST" 
                          onsubmit="return confirm('Yakin ingin menghapus template ini?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" 
                                class="bg-red-500/20 hover:bg-red-500/30 border border-red-500/30 text-red-400 px-3 py-2 rounded-lg text-sm transition">
                            <i data-lucide="trash-2" class="w-4 h-4"></i>
                        </button>
                    </form>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="bg-surface border border-border rounded-xl p-12 text-center">
            <i data-lucide="file-edit" class="w-16 h-16 text-gray-600 mx-auto mb-4"></i>
            <p class="text-gray-400 mb-4">Belum ada notification templates</p>
            <a href="<?php echo e(route('notification-templates.create')); ?>" class="inline-block bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm transition">
                Buat Template Pertama
            </a>
        </div>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if(method_exists($templates, 'links')): ?>
    <div class="mt-6">
        <?php echo e($templates->links()); ?>

    </div>
    <?php endif; ?>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    if (window.lucide) {
        lucide.createIcons();
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/kor.copilotproduction.com/resources/views/notification-templates/index.blade.php ENDPATH**/ ?>