

<?php $__env->startSection('title', 'Data Petugas'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <h2 class="text-3xl font-bold mb-6">Data Petugas Lapangan</h2>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Nama</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">NIP</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Polsek</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Lokasi</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $officers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $officer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium"><?php echo e($officer->user->name); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e($officer->nip); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e(ucfirst($officer->unit_type)); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e($officer->polsek?->name ?? '-'); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 py-1 text-xs rounded-full
                            <?php echo e($officer->status === 'available' ? 'bg-green-100 text-green-800' : ''); ?>

                            <?php echo e($officer->status === 'busy' ? 'bg-yellow-100 text-yellow-800' : ''); ?>">
                            <?php echo e(ucfirst(str_replace('_', ' ', $officer->status))); ?>

                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <?php if($officer->current_latitude && $officer->current_longitude): ?>
                            <?php echo e($officer->current_latitude); ?>, <?php echo e($officer->current_longitude); ?>

                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-gray-500">Tidak ada data petugas</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        <?php echo e($officers->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\callcenter\resources\views/officers/index.blade.php ENDPATH**/ ?>