

<?php $__env->startSection('title', 'Koordinasi'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <h2 class="text-3xl font-bold mb-6">Koordinasi Internal & Eksternal</h2>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Aduan</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tipe</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Penerima</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Waktu</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $coordinations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coordination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <?php echo e($coordination->complaint->ticket_number); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <?php echo e(ucfirst($coordination->type)); ?>

                        <?php if($coordination->type === 'external'): ?>
                            - <?php echo e(strtoupper($coordination->external_type)); ?>

                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <?php echo e($coordination->recipient_name ?? '-'); ?><br>
                        <span class="text-xs text-gray-500"><?php echo e($coordination->recipient_phone ?? $coordination->recipient_email ?? '-'); ?></span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 py-1 text-xs rounded-full
                            <?php echo e($coordination->status === 'completed' ? 'bg-green-100 text-green-800' : ''); ?>

                            <?php echo e($coordination->status === 'pending' ? 'bg-yellow-100 text-yellow-800' : ''); ?>">
                            <?php echo e(ucfirst($coordination->status)); ?>

                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <?php echo e($coordination->created_at->format('d/m/Y H:i')); ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="px-6 py-4 text-center text-gray-500">Tidak ada data koordinasi</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        <?php echo e($coordinations->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/kor.copilotproduction.com/resources/views/coordinations/index.blade.php ENDPATH**/ ?>