<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="h-full antialiased">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title', 'Dashboard'); ?> - <?php echo e(config('app.name', 'Command Center')); ?></title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">

    <!-- Tailwind CDN for extended theming -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: { sans: ['Inter', 'sans-serif'] },
                    colors: {
                        background: '#0B0E14',
                        surface: '#151921',
                        border: '#2A2F3A',
                    }
                }
            }
        }
    </script>

    <!-- Leaflet (maps) -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css">
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

    <!-- Lucide icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <style>
        body { background-color: #0B0E14; color: #E5E7EB; }
        .glass-panel { background: rgba(21, 25, 33, 0.8); backdrop-filter: blur(12px); border: 1px solid rgba(255,255,255,0.08); }
        .status-dot { box-shadow: 0 0 0 2px #151921; }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<?php $activeRoute = request()->route() ? request()->route()->getName() : ''; $user = auth()->user(); ?>
<body class="min-h-screen flex flex-col font-sans bg-background text-sm text-gray-200">
    <!-- Header -->
    <header class="h-14 border-b border-border bg-surface/70 backdrop-blur flex items-center justify-between px-4 sticky top-0 z-40">
        <div class="flex items-center gap-4">
            <div class="flex items-center gap-2">
                <div class="h-6 w-6 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-md flex items-center justify-center shadow-lg shadow-indigo-500/20">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-white" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/></svg>
                </div>
                <h1 class="text-base font-semibold tracking-tight text-white"><?php echo e(config('app.name', 'Command Center')); ?></h1>
            </div>
            <div class="hidden md:flex items-center gap-2 text-xs text-gray-400">
                <span class="flex items-center gap-1">
                    <span class="relative flex h-2 w-2">
                        <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-green-400 opacity-75"></span>
                        <span class="relative inline-flex rounded-full h-2 w-2 bg-green-500"></span>
                    </span>
                    Sistem Online
                </span>
                <span class="text-gray-600">•</span>
                <span class="font-mono text-gray-500">Lat: -6.2</span>
                <span class="font-mono text-gray-500">Long: 106.8</span>
            </div>
        </div>
        <div class="flex items-center gap-3">
            <div class="hidden md:flex items-center gap-2 bg-white/5 border border-white/5 rounded-full px-3 py-1 text-xs text-red-400 font-medium">
                SIAGA 1
            </div>
            <div class="flex items-center gap-2">
                <span class="text-xs text-gray-400"><?php echo e($user?->name); ?></span>
                <span class="px-2 py-1 text-[10px] rounded-full bg-white/5 border border-white/10">
                    <?php echo e(ucfirst($user->role ?? 'guest')); ?>

                </span>
            </div>
        </div>
    </header>

    <div class="flex flex-1 overflow-hidden">
        <!-- Sidebar -->
        <aside class="hidden md:flex w-20 md:w-64 flex-col justify-between border-r border-border bg-surface">
            <nav class="p-3 space-y-1">
                <?php
                    $navItems = [
                        ['route' => 'dashboard', 'label' => 'GIS Dashboard', 'icon' => 'map'],
                        ['route' => 'complaints.index', 'label' => 'Aduan Masuk', 'icon' => 'phone'],
                        ['route' => 'dispatches.index', 'label' => 'Dispatch', 'icon' => 'radio'],
                        ['route' => 'cctvs.index', 'label' => 'CCTV Network', 'icon' => 'video'],
                        ['route' => 'panic-buttons.index', 'label' => 'Panic Button', 'icon' => 'alert-triangle'],
                        ['route' => 'officers.index', 'label' => 'Unit Lapangan', 'icon' => 'users'],
                        ['route' => 'knowledge-center.index', 'label' => 'Knowledge Center', 'icon' => 'book-open'],
                        ['route' => 'analytics.index', 'label' => 'Analytics', 'icon' => 'activity'],
                    ];
                ?>
                <?php $__currentLoopData = $navItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $hasRoute = Route::has($item['route']); ?>
                    <a href="<?php echo e($hasRoute ? route($item['route']) : '#'); ?>"
                       <?php if(! $hasRoute): ?> aria-disabled="true" <?php endif; ?>
                       class="flex items-center gap-3 px-3 py-2 rounded-md border border-transparent text-sm transition
                              <?php echo e($activeRoute === $item['route'] ? 'bg-white/10 border-white/10 text-white' : 'text-gray-400 hover:bg-white/5 hover:text-white'); ?>

                              <?php echo e($hasRoute ? '' : 'opacity-60 cursor-not-allowed'); ?>">
                        <i data-lucide="<?php echo e($item['icon']); ?>" class="w-4 h-4"></i>
                        <span class="hidden md:block font-medium"><?php echo e($item['label']); ?></span>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </nav>
            <form method="POST" action="<?php echo e(route('logout')); ?>" class="p-3">
                <?php echo csrf_field(); ?>
                <button class="w-full px-3 py-2 text-left text-xs text-gray-400 hover:bg-white/5 rounded-md flex items-center gap-2">
                    <i data-lucide="log-out" class="w-4 h-4"></i> Logout
                </button>
            </form>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 overflow-y-auto bg-background">
            <div class="max-w-[1920px] mx-auto p-6 space-y-6">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>

        <!-- Right Sidebar (static for now) -->
        <aside class="hidden xl:flex w-72 border-l border-border bg-surface flex-col">
            <div class="p-4 border-b border-border">
                <h3 class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2">Stakeholder Nasional</h3>
                <p class="text-xs text-gray-400">Integrasi instansi (Damkar, RS, BNPB, dll)</p>
            </div>
            <div class="flex-1 overflow-y-auto p-4 space-y-4 text-xs text-gray-400">
                <p>Mabes Polri • Status: Online</p>
                <p>BNPB • Status: Siaga</p>
                <p>Damkar Jakarta • Status: Standby</p>
                <p>Kemenkes RI • Status: On-call</p>
            </div>
        </aside>
    </div>

    <?php echo $__env->yieldPushContent('scripts'); ?>
    <script> if(window.lucide){ lucide.createIcons(); } </script>
</body>
</html>
<?php /**PATH C:\laragon\www\callcenter\resources\views/layouts/app.blade.php ENDPATH**/ ?>