

<?php $__env->startSection('title', 'Tambah Automation Rule'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-3xl font-bold text-white">Tambah Automation Rule</h2>
            <p class="text-gray-400 text-sm mt-1">Buat aturan automasi baru</p>
        </div>
        <a href="<?php echo e(route('automation-rules.index')); ?>" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-4 py-2 rounded-lg text-sm transition">
            ← Kembali
        </a>
    </div>

    <form action="<?php echo e(route('automation-rules.store')); ?>" method="POST" class="bg-surface border border-border rounded-xl p-6">
        <?php echo csrf_field(); ?>

        <div class="space-y-6">
            <!-- Basic Info -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Nama Rule *</label>
                <input type="text" name="name" value="<?php echo e(old('name')); ?>" required
                       class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500">
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-red-400 text-xs mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Deskripsi</label>
                <textarea name="description" rows="2"
                          class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo e(old('description')); ?></textarea>
            </div>

            <!-- Trigger Event -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Trigger Event *</label>
                <select name="trigger_event" required
                        class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Pilih Trigger Event</option>
                    <option value="complaint.created" <?php echo e(old('trigger_event') == 'complaint.created' ? 'selected' : ''); ?>>Complaint Created</option>
                    <option value="dispatch.no_response" <?php echo e(old('trigger_event') == 'dispatch.no_response' ? 'selected' : ''); ?>>Dispatch No Response</option>
                    <option value="dispatch.accepted" <?php echo e(old('trigger_event') == 'dispatch.accepted' ? 'selected' : ''); ?>>Dispatch Accepted</option>
                    <option value="panic_button.activated" <?php echo e(old('trigger_event') == 'panic_button.activated' ? 'selected' : ''); ?>>Panic Button Activated</option>
                </select>
                <?php $__errorArgs = ['trigger_event'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-red-400 text-xs mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Conditions -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Conditions (JSON) *</label>
                <textarea name="conditions" rows="6" required
                          class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 font-mono text-sm text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500"
                          placeholder='{"priority": "critical"}'><?php echo e(old('conditions', '{}')); ?></textarea>
                <p class="text-gray-500 text-xs mt-1">Format JSON. Contoh: {"priority": "critical", "has_location": true}</p>
                <?php $__errorArgs = ['conditions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-red-400 text-xs mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Actions -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Actions (JSON Array) *</label>
                <textarea name="actions" rows="4" required
                          class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 font-mono text-sm text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500"
                          placeholder='["auto_dispatch", "notify_supervisor"]'><?php echo e(old('actions', '[]')); ?></textarea>
                <p class="text-gray-500 text-xs mt-1">Format JSON Array. Contoh: ["auto_dispatch", "capture_cctv", "notify_supervisor"]</p>
                <?php $__errorArgs = ['actions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-red-400 text-xs mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Action Params -->
            <div>
                <label class="block text-sm font-medium text-gray-300 mb-2">Action Parameters (JSON, Optional)</label>
                <textarea name="action_params" rows="4"
                          class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 font-mono text-sm text-white placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-500"
                          placeholder='{"reason": "Auto-escalation"}'><?php echo e(old('action_params', '{}')); ?></textarea>
            </div>

            <!-- Priority & Status -->
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Priority (0-100)</label>
                    <input type="number" name="priority" value="<?php echo e(old('priority', 0)); ?>" min="0" max="100"
                           class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-300 mb-2">Status</label>
                    <select name="is_active"
                            class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-white focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="1" <?php echo e(old('is_active', true) ? 'selected' : ''); ?>>Aktif</option>
                        <option value="0" <?php echo e(!old('is_active', true) ? 'selected' : ''); ?>>Nonaktif</option>
                    </select>
                </div>
            </div>

            <!-- Submit -->
            <div class="flex gap-3 pt-4">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg transition">
                    Simpan Rule
                </button>
                <a href="<?php echo e(route('automation-rules.index')); ?>" class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-6 py-2 rounded-lg transition">
                    Batal
                </a>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/kor.copilotproduction.com/resources/views/automation-rules/create.blade.php ENDPATH**/ ?>