

<?php $__env->startSection('title', 'Automation Rules'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <div class="flex justify-between items-center mb-6">
        <div>
            <h2 class="text-3xl font-bold text-white">Automation Rules</h2>
            <p class="text-gray-400 text-sm mt-1">Kelola aturan automasi sistem</p>
        </div>
        <a href="<?php echo e(route('automation-rules.create')); ?>" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm transition flex items-center gap-2">
            <i data-lucide="plus" class="w-4 h-4"></i>
            Tambah Rule
        </a>
    </div>

    <!-- Rules List -->
    <div class="space-y-4">
        <?php $__empty_1 = true; $__currentLoopData = $rules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="bg-surface border border-border rounded-xl p-6 hover:border-blue-500/30 transition">
            <div class="flex justify-between items-start">
                <div class="flex-1">
                    <div class="flex items-center gap-3 mb-3">
                        <h3 class="text-lg font-semibold text-white"><?php echo e($rule->name); ?></h3>
                        <?php if($rule->is_active): ?>
                        <span class="px-2 py-1 bg-green-500/20 text-green-400 text-xs rounded-full border border-green-500/30">
                            Aktif
                        </span>
                        <?php else: ?>
                        <span class="px-2 py-1 bg-gray-500/20 text-gray-400 text-xs rounded-full border border-gray-500/30">
                            Nonaktif
                        </span>
                        <?php endif; ?>
                        <span class="px-2 py-1 bg-blue-500/20 text-blue-400 text-xs rounded-full border border-blue-500/30">
                            Priority: <?php echo e($rule->priority); ?>

                        </span>
                    </div>
                    <?php if($rule->description): ?>
                    <p class="text-gray-400 text-sm mb-4"><?php echo e($rule->description); ?></p>
                    <?php endif; ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                        <div>
                            <p class="text-gray-500 mb-1">Trigger Event</p>
                            <p class="text-blue-400 font-mono"><?php echo e($rule->trigger_event); ?></p>
                        </div>
                        <div>
                            <p class="text-gray-500 mb-1">Actions</p>
                            <div class="flex flex-wrap gap-2">
                                <?php $__currentLoopData = $rule->actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="px-2 py-1 bg-green-500/20 text-green-400 text-xs rounded border border-green-500/30">
                                    <?php echo e($action); ?>

                                </span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div>
                            <p class="text-gray-500 mb-1">Conditions</p>
                            <pre class="text-gray-400 text-xs font-mono bg-white/5 p-2 rounded"><?php echo e(json_encode($rule->conditions, JSON_PRETTY_PRINT)); ?></pre>
                        </div>
                        <div>
                            <p class="text-gray-500 mb-1">Statistics</p>
                            <p class="text-gray-400 text-xs">
                                Executed: <?php echo e($rule->execution_count); ?>x
                                <?php if($rule->last_executed_at): ?>
                                <br>Last: <?php echo e($rule->last_executed_at->diffForHumans()); ?>

                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="flex gap-2 ml-4">
                    <a href="<?php echo e(route('automation-rules.show', $rule)); ?>" 
                       class="bg-white/5 hover:bg-white/10 border border-white/10 text-white px-3 py-2 rounded-lg text-sm transition">
                        <i data-lucide="eye" class="w-4 h-4"></i>
                    </a>
                    <a href="<?php echo e(route('automation-rules.edit', $rule)); ?>" 
                       class="bg-blue-500/20 hover:bg-blue-500/30 border border-blue-500/30 text-blue-400 px-3 py-2 rounded-lg text-sm transition">
                        <i data-lucide="edit" class="w-4 h-4"></i>
                    </a>
                    <form action="<?php echo e(route('automation-rules.destroy', $rule)); ?>" method="POST" 
                          onsubmit="return confirm('Yakin ingin menghapus rule ini?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" 
                                class="bg-red-500/20 hover:bg-red-500/30 border border-red-500/30 text-red-400 px-3 py-2 rounded-lg text-sm transition">
                            <i data-lucide="trash-2" class="w-4 h-4"></i>
                        </button>
                    </form>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="bg-surface border border-border rounded-xl p-12 text-center">
            <i data-lucide="settings" class="w-16 h-16 text-gray-600 mx-auto mb-4"></i>
            <p class="text-gray-400 mb-4">Belum ada automation rules</p>
            <a href="<?php echo e(route('automation-rules.create')); ?>" class="inline-block bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm transition">
                Buat Rule Pertama
            </a>
        </div>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if(method_exists($rules, 'links')): ?>
    <div class="mt-6">
        <?php echo e($rules->links()); ?>

    </div>
    <?php endif; ?>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    if (window.lucide) {
        lucide.createIcons();
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/kor.copilotproduction.com/resources/views/automation-rules/index.blade.php ENDPATH**/ ?>