

<?php $__env->startSection('title', 'Knowledge Center'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold">Knowledge Center</h2>
        <?php if(auth()->user()->role === 'admin'): ?>
            <a href="<?php echo e(route('knowledge-center.create')); ?>" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                + Tambah Artikel
            </a>
        <?php endif; ?>
    </div>

    <form method="GET" class="mb-6 flex gap-4">
        <select name="category" class="border rounded px-3 py-2">
            <option value="">Semua Kategori</option>
            <option value="safety_guide" <?php echo e(request('category') == 'safety_guide' ? 'selected' : ''); ?>>Safety Guide</option>
            <option value="digital_safety" <?php echo e(request('category') == 'digital_safety' ? 'selected' : ''); ?>>Digital Safety</option>
            <option value="emergency_procedure" <?php echo e(request('category') == 'emergency_procedure' ? 'selected' : ''); ?>>Emergency Procedure</option>
            <option value="training" <?php echo e(request('category') == 'training' ? 'selected' : ''); ?>>Training</option>
            <option value="security_article" <?php echo e(request('category') == 'security_article' ? 'selected' : ''); ?>>Security Article</option>
        </select>
        <input type="text" name="search" class="border rounded px-3 py-2 flex-1" placeholder="Cari artikel..." value="<?php echo e(request('search')); ?>">
        <button type="submit" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            Cari
        </button>
    </form>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <?php $__empty_1 = true; $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="bg-white rounded-lg shadow overflow-hidden">
            <div class="p-6">
                <div class="flex items-center justify-between text-sm text-gray-500 mb-2">
                    <span class="px-2 py-1 text-xs rounded-full bg-blue-100 text-blue-800">
                        <?php echo e(ucfirst(str_replace('_', ' ', $article->category))); ?>

                    </span>
                    <span><?php echo e($article->created_at->format('d M Y')); ?></span>
                </div>
                <h3 class="text-xl font-bold mb-2"><?php echo e($article->title); ?></h3>
                <p class="text-gray-600 mb-4"><?php echo e($article->excerpt); ?></p>
                <a href="<?php echo e(route('knowledge-center.show', $article)); ?>" class="text-blue-600 hover:text-blue-900">
                    Baca selengkapnya →
                </a>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p class="text-gray-500">Belum ada artikel</p>
        <?php endif; ?>
    </div>

    <div class="mt-6">
        <?php echo e($articles->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\callcenter\resources\views/knowledge-center/index.blade.php ENDPATH**/ ?>