

<?php $__env->startSection('title', 'Notification & Automation Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <div class="mb-6">
        <h1 class="text-3xl font-bold text-white mb-2">Notification & Automation</h1>
        <p class="text-gray-400">Kelola notifikasi dan aturan automasi sistem</p>
    </div>

    <!-- Automation Rules -->
    <div class="bg-surface border border-border rounded-xl p-6 mb-6">
        <div class="flex justify-between items-center mb-4">
            <h2 class="text-xl font-semibold text-white">Automation Rules</h2>
            <button class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm">
                + Tambah Rule
            </button>
        </div>
        <div class="space-y-4">
            <?php $__empty_1 = true; $__currentLoopData = $automationRules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white/5 border border-white/10 rounded-lg p-4">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <div class="flex items-center gap-2 mb-2">
                            <h3 class="text-white font-semibold"><?php echo e($rule['name']); ?></h3>
                            <?php if($rule['is_active']): ?>
                            <span class="px-2 py-1 bg-green-500/20 text-green-400 text-xs rounded-full border border-green-500/30">
                                Aktif
                            </span>
                            <?php else: ?>
                            <span class="px-2 py-1 bg-gray-500/20 text-gray-400 text-xs rounded-full border border-gray-500/30">
                                Nonaktif
                            </span>
                            <?php endif; ?>
                        </div>
                        <p class="text-gray-400 text-sm mb-2"><?php echo e($rule['description']); ?></p>
                        <div class="flex flex-wrap gap-2 text-xs">
                            <span class="text-gray-500">Trigger:</span>
                            <span class="text-blue-400"><?php echo e($rule['trigger']); ?></span>
                            <span class="text-gray-500 ml-2">Actions:</span>
                            <?php $__currentLoopData = $rule['actions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="text-green-400"><?php echo e($action); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="flex gap-2">
                        <button class="text-blue-400 hover:text-blue-300 text-sm">Edit</button>
                        <button class="text-red-400 hover:text-red-300 text-sm">Hapus</button>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center text-gray-400 py-8">
                Tidak ada automation rules
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Recent Notifications -->
    <div class="bg-surface border border-border rounded-xl p-6">
        <h2 class="text-xl font-semibold text-white mb-4">Recent Notifications</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full">
                <thead class="bg-white/5">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Waktu</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Tipe</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Penerima</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Pesan</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Status</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-white/5">
                    <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-white/5">
                        <td class="px-6 py-4 whitespace-nowrap text-gray-400 text-sm">
                            <?php echo e($notification->created_at->format('d/m/Y H:i')); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 bg-blue-500/20 text-blue-400 text-xs rounded-full">
                                <?php echo e(ucfirst($notification->type ?? 'notification')); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-white text-sm">
                            <?php echo e($notification->user->name ?? ($notification->sender->name ?? 'System')); ?>

                        </td>
                        <td class="px-6 py-4 text-gray-300 text-sm">
                            <?php echo e(\Illuminate\Support\Str::limit($notification->message ?? $notification->title ?? '-', 50)); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <?php if($notification->read_at): ?>
                            <span class="text-green-400 text-xs">Read</span>
                            <?php else: ?>
                            <span class="text-yellow-400 text-xs">Unread</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-4 text-center text-gray-400">
                            Tidak ada notifikasi
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if(method_exists($notifications, 'links')): ?>
        <div class="mt-4">
            <?php echo e($notifications->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/kor.copilotproduction.com/resources/views/notifications/index.blade.php ENDPATH**/ ?>