

<?php $__env->startSection('title', 'Detail CCTV - ' . $cctv->name); ?>

<?php $__env->startSection('content'); ?>
<div>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold">Detail CCTV: <?php echo e($cctv->name); ?></h2>
        <a href="<?php echo e(route('cctvs.index')); ?>" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            ← Kembali
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Informasi CCTV</h3>
            <dl class="space-y-2">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Nama</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($cctv->name); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Code</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($cctv->code); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Sumber</dt>
                    <dd class="text-sm text-gray-900"><?php echo e(ucfirst($cctv->source)); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Status</dt>
                    <dd class="text-sm">
                        <span class="px-2 py-1 text-xs rounded-full 
                            <?php echo e($cctv->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                            <?php echo e(ucfirst($cctv->status)); ?>

                        </span>
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Alamat</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($cctv->address); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Radius Coverage</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($cctv->radius_coverage); ?> meter</dd>
                </div>
            </dl>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Lokasi</h3>
            <p class="text-sm text-gray-900 mb-2">Koordinat: <?php echo e($cctv->latitude); ?>, <?php echo e($cctv->longitude); ?></p>
            <div id="map" style="height: 300px; width: 100%;"></div>
        </div>
    </div>

    <?php if($cctv->snapshots->count() > 0): ?>
    <div class="bg-white rounded-lg shadow p-6 mt-6">
        <h3 class="text-xl font-bold mb-4">Snapshots Terbaru</h3>
        <div class="grid grid-cols-4 gap-4">
            <?php $__currentLoopData = $cctv->snapshots->take(8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $snapshot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <img src="<?php echo e($snapshot->snapshot_url); ?>" alt="Snapshot" class="w-full h-32 object-cover rounded">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    var map = L.map('map').setView([<?php echo e($cctv->latitude); ?>, <?php echo e($cctv->longitude); ?>], 15);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png').addTo(map);
    L.marker([<?php echo e($cctv->latitude); ?>, <?php echo e($cctv->longitude); ?>]).addTo(map);
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/kor.copilotproduction.com/resources/views/cctvs/show.blade.php ENDPATH**/ ?>