

<?php $__env->startSection('title', 'Daftar Aduan'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <?php $canCreateComplaints = auth()->check() && Route::has('complaints.create'); ?>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold">Daftar Aduan</h2>
        <?php if($canCreateComplaints): ?>
            <a href="<?php echo e(route('complaints.create')); ?>" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                + Tambah Aduan
            </a>
        <?php endif; ?>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow p-4 mb-6">
        <form method="GET" action="<?php echo e(route('complaints.index')); ?>" class="flex gap-4">
            <select name="status" class="border rounded px-3 py-2">
                <option value="">Semua Status</option>
                <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="processing" <?php echo e(request('status') == 'processing' ? 'selected' : ''); ?>>Processing</option>
                <option value="dispatched" <?php echo e(request('status') == 'dispatched' ? 'selected' : ''); ?>>Dispatched</option>
                <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>Completed</option>
            </select>
            <select name="category" class="border rounded px-3 py-2">
                <option value="">Semua Kategori</option>
                <option value="emergency_police" <?php echo e(request('category') == 'emergency_police' ? 'selected' : ''); ?>>Emergency Polisi</option>
                <option value="emergency_medical" <?php echo e(request('category') == 'emergency_medical' ? 'selected' : ''); ?>>Emergency Medis</option>
                <option value="emergency_fire" <?php echo e(request('category') == 'emergency_fire' ? 'selected' : ''); ?>>Emergency Kebakaran</option>
                <option value="non_emergency" <?php echo e(request('category') == 'non_emergency' ? 'selected' : ''); ?>>Non Emergency</option>
            </select>
            <button type="submit" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
                Filter
            </button>
        </form>
    </div>

    <!-- Table -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ticket</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Sumber</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Kategori</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Waktu</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Aksi</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $complaints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $complaint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium"><?php echo e($complaint->ticket_number); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e(ucfirst($complaint->source)); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 py-1 text-xs rounded-full bg-blue-100 text-blue-800">
                            <?php echo e(ucfirst(str_replace('_', ' ', $complaint->category))); ?>

                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 py-1 text-xs rounded-full 
                            <?php echo e($complaint->status == 'completed' ? 'bg-green-100 text-green-800' : ''); ?>

                            <?php echo e($complaint->status == 'pending' ? 'bg-yellow-100 text-yellow-800' : ''); ?>

                            <?php echo e($complaint->status == 'processing' ? 'bg-orange-100 text-orange-800' : ''); ?>

                            <?php echo e($complaint->status == 'dispatched' ? 'bg-blue-100 text-blue-800' : ''); ?>">
                            <?php echo e(ucfirst($complaint->status)); ?>

                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e($complaint->created_at->format('d/m/Y H:i')); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <a href="<?php echo e(route('complaints.show', $complaint)); ?>" class="text-blue-600 hover:text-blue-900">Detail</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-gray-500">Tidak ada data aduan</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="mt-4">
        <?php echo e($complaints->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\callcenter\resources\views/complaints/index.blade.php ENDPATH**/ ?>