

<?php $__env->startSection('title', 'Analytics & Heatmap'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <h2 class="text-3xl font-bold mb-6">Analytics & Heatmap Kriminal</h2>

    <form method="GET" class="mb-6 flex gap-4 items-end">
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Mulai</label>
            <input type="date" name="start_date" value="<?php echo e($startDate); ?>" class="border rounded px-3 py-2">
        </div>
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Selesai</label>
            <input type="date" name="end_date" value="<?php echo e($endDate); ?>" class="border rounded px-3 py-2">
        </div>
        <button type="submit" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            Tampilkan
        </button>
    </form>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Ringkasan</h3>
            <dl class="grid grid-cols-2 gap-4">
                <div>
                    <dt class="text-sm text-gray-500">Total Aduan</dt>
                    <dd class="text-2xl font-bold"><?php echo e($stats['total']); ?></dd>
                </div>
                <div>
                    <dt class="text-sm text-gray-500">Emergency</dt>
                    <dd class="text-2xl font-bold text-red-600"><?php echo e($stats['emergency']); ?></dd>
                </div>
                <div>
                    <dt class="text-sm text-gray-500">Non Emergency</dt>
                    <dd class="text-2xl font-bold text-blue-600"><?php echo e($stats['non_emergency']); ?></dd>
                </div>
                <div>
                    <dt class="text-sm text-gray-500">Selesai</dt>
                    <dd class="text-2xl font-bold text-green-600"><?php echo e($stats['completed']); ?></dd>
                </div>
            </dl>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Response Time</h3>
            <dl class="grid grid-cols-2 gap-4">
                <div>
                    <dt class="text-sm text-gray-500">Rata-rata Respon</dt>
                    <dd class="text-2xl font-bold text-orange-600"><?php echo e($responseTimeStats['avg_response_time']); ?> mnt</dd>
                </div>
                <div>
                    <dt class="text-sm text-gray-500">Rata-rata Selesai</dt>
                    <dd class="text-2xl font-bold text-purple-600"><?php echo e($responseTimeStats['avg_resolution_time']); ?> mnt</dd>
                </div>
            </dl>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h3 class="text-xl font-bold mb-4">Heatmap Lokasi</h3>
        <div id="heatmap" style="height: 400px;"></div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-xl font-bold mb-4">Statistik Jam</h3>
        <div class="grid grid-cols-6 gap-4">
            <?php $__currentLoopData = $hourlyStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hour => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="text-center p-4 bg-gray-50 rounded">
                <p class="text-sm text-gray-500"><?php echo e(str_pad($hour, 2, '0', STR_PAD_LEFT)); ?>:00</p>
                <p class="text-2xl font-bold"><?php echo e($count); ?></p>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    var map = L.map('heatmap').setView([-2.5489, 118.0149], 5);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png').addTo(map);

    <?php $__currentLoopData = $heatmapData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        L.circle([<?php echo e($point['lat']); ?>, <?php echo e($point['lng']); ?>], {
            color: 'red',
            fillColor: '#f03',
            fillOpacity: 0.5,
            radius: <?php echo e($point['count'] * 50); ?>

        }).addTo(map).bindPopup('Aduan: <?php echo e($point['count']); ?><br>Kategori: <?php echo e($point['category']); ?>');
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/kor.copilotproduction.com/resources/views/analytics/index.blade.php ENDPATH**/ ?>