

<?php $__env->startSection('title', 'Broadcast Alert System'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <div class="mb-6">
        <h1 class="text-3xl font-bold text-white mb-2">Broadcast Alert System</h1>
        <p class="text-gray-400">Kirim peringatan darurat ke seluruh unit</p>
    </div>

    <!-- Create Broadcast Form -->
    <div class="bg-surface border border-border rounded-xl p-6 mb-6">
        <h2 class="text-xl font-semibold text-white mb-4">Buat Broadcast Baru</h2>
        <form id="broadcastForm" class="space-y-4">
            <?php echo csrf_field(); ?>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Judul</label>
                    <input type="text" name="title" required
                           class="w-full bg-surface border border-border rounded-lg px-4 py-2 text-white">
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Tipe</label>
                    <select name="type" required
                            class="w-full bg-surface border border-border rounded-lg px-4 py-2 text-white">
                        <option value="emergency">Emergency</option>
                        <option value="disaster">Bencana</option>
                        <option value="crime_alert">Peringatan Kriminal</option>
                        <option value="general">Umum</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Prioritas</label>
                    <select name="priority" required
                            class="w-full bg-surface border border-border rounded-lg px-4 py-2 text-white">
                        <option value="low">Rendah</option>
                        <option value="medium">Sedang</option>
                        <option value="high">Tinggi</option>
                        <option value="critical">Kritis</option>
                    </select>
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-1">Target Scope</label>
                    <select name="target_scope" id="target_scope" required
                            class="w-full bg-surface border border-border rounded-lg px-4 py-2 text-white">
                        <option value="national">Nasional</option>
                        <option value="polda">Polda</option>
                        <option value="polres">Polres</option>
                        <option value="polsek">Polsek</option>
                    </select>
                </div>
            </div>
            <div>
                <label class="block text-sm text-gray-400 mb-1">Pesan</label>
                <textarea name="message" rows="4" required
                          class="w-full bg-surface border border-border rounded-lg px-4 py-2 text-white"></textarea>
            </div>
            <div>
                <label class="block text-sm text-gray-400 mb-2">Channel</label>
                <div class="flex flex-wrap gap-4">
                    <label class="flex items-center gap-2">
                        <input type="checkbox" name="channels[]" value="mobile_app" checked
                               class="rounded border-border">
                        <span class="text-white text-sm">Mobile App</span>
                    </label>
                    <label class="flex items-center gap-2">
                        <input type="checkbox" name="channels[]" value="whatsapp" checked
                               class="rounded border-border">
                        <span class="text-white text-sm">WhatsApp</span>
                    </label>
                    <label class="flex items-center gap-2">
                        <input type="checkbox" name="channels[]" value="sms" checked
                               class="rounded border-border">
                        <span class="text-white text-sm">SMS</span>
                    </label>
                    <label class="flex items-center gap-2">
                        <input type="checkbox" name="channels[]" value="radio"
                               class="rounded border-border">
                        <span class="text-white text-sm">Radio</span>
                    </label>
                    <label class="flex items-center gap-2">
                        <input type="checkbox" name="channels[]" value="email"
                               class="rounded border-border">
                        <span class="text-white text-sm">Email</span>
                    </label>
                </div>
            </div>
            <div>
                <button type="submit" 
                        class="bg-red-600 hover:bg-red-700 text-white px-6 py-2 rounded-lg font-semibold">
                    Kirim Broadcast
                </button>
            </div>
        </form>
    </div>

    <!-- Recent Broadcasts -->
    <div class="bg-surface border border-border rounded-xl p-6">
        <h2 class="text-xl font-semibold text-white mb-4">Recent Broadcasts</h2>
        <div class="space-y-4">
            <?php $__empty_1 = true; $__currentLoopData = $broadcasts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $broadcast): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white/5 border border-white/10 rounded-lg p-4">
                <div class="flex justify-between items-start mb-2">
                    <div>
                        <h3 class="text-white font-semibold"><?php echo e($broadcast->title); ?></h3>
                        <p class="text-gray-400 text-sm mt-1"><?php echo e($broadcast->message); ?></p>
                    </div>
                    <div class="text-right">
                        <span class="px-2 py-1 bg-red-500/20 text-red-400 text-xs rounded-full border border-red-500/30">
                            <?php echo e(ucfirst($broadcast->metadata['broadcast_type'] ?? 'general')); ?>

                        </span>
                        <p class="text-gray-400 text-xs mt-2">
                            <?php echo e($broadcast->created_at->format('d/m/Y H:i')); ?>

                        </p>
                    </div>
                </div>
                <div class="flex flex-wrap gap-2 text-xs">
                    <span class="text-gray-500">Target:</span>
                    <span class="text-blue-400"><?php echo e(ucfirst($broadcast->metadata['target_scope'] ?? 'national')); ?></span>
                    <span class="text-gray-500 ml-2">Channels:</span>
                    <?php $__currentLoopData = $broadcast->metadata['channels'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $channel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span class="text-green-400"><?php echo e(ucfirst($channel)); ?></span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center text-gray-400 py-8">
                Belum ada broadcast
            </div>
            <?php endif; ?>
        </div>
        <?php if(method_exists($broadcasts, 'links')): ?>
        <div class="mt-4">
            <?php echo e($broadcasts->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.getElementById('broadcastForm').addEventListener('submit', async function(e) {
        e.preventDefault();
        const formData = new FormData(this);
        const data = Object.fromEntries(formData);
        data.channels = formData.getAll('channels[]');

        try {
            const response = await fetch('<?php echo e(route("broadcasts.store")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify(data)
            });

            const result = await response.json();
            if (result.success) {
                alert('Broadcast berhasil dikirim!');
                location.reload();
            } else {
                alert('Gagal mengirim broadcast');
            }
        } catch (error) {
            console.error(error);
            alert('Terjadi kesalahan');
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/kor.copilotproduction.com/resources/views/broadcasts/index.blade.php ENDPATH**/ ?>