

<?php $__env->startSection('title', 'Detail Panic Button - ' . $panicButton->name); ?>

<?php $__env->startSection('content'); ?>
<div>
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-3xl font-bold">Detail Panic Button: <?php echo e($panicButton->name); ?></h2>
        <a href="<?php echo e(route('panic-buttons.index')); ?>" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
            ← Kembali
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Informasi Panic Button</h3>
            <dl class="space-y-2">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Nama</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($panicButton->name); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Code</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($panicButton->code); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Tipe</dt>
                    <dd class="text-sm text-gray-900"><?php echo e(ucfirst(str_replace('_', ' ', $panicButton->type))); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Status</dt>
                    <dd class="text-sm">
                        <span class="px-2 py-1 text-xs rounded-full 
                            <?php echo e($panicButton->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                            <?php echo e(ucfirst($panicButton->status)); ?>

                        </span>
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Alamat</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($panicButton->address); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Terakhir Diaktifkan</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($panicButton->last_activated_at ? $panicButton->last_activated_at->format('d/m/Y H:i:s') : '-'); ?></dd>
                </div>
            </dl>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Lokasi</h3>
            <p class="text-sm text-gray-900 mb-2">Koordinat: <?php echo e($panicButton->latitude); ?>, <?php echo e($panicButton->longitude); ?></p>
            <div id="map" style="height: 300px; width: 100%;"></div>
        </div>
    </div>

    <?php if($panicButton->activations->count() > 0): ?>
    <div class="bg-white rounded-lg shadow p-6 mt-6">
        <h3 class="text-xl font-bold mb-4">Riwayat Aktivasi</h3>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Waktu</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $panicButton->activations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e($activation->activated_at->format('d/m/Y H:i:s')); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 py-1 text-xs rounded-full bg-blue-100 text-blue-800">
                                <?php echo e(ucfirst($activation->status)); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <?php if($activation->complaint): ?>
                            <a href="<?php echo e(route('complaints.show', $activation->complaint)); ?>" class="text-blue-600 hover:text-blue-900">Lihat Aduan</a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    var map = L.map('map').setView([<?php echo e($panicButton->latitude); ?>, <?php echo e($panicButton->longitude); ?>], 15);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png').addTo(map);
    L.marker([<?php echo e($panicButton->latitude); ?>, <?php echo e($panicButton->longitude); ?>]).addTo(map);
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/kor.copilotproduction.com/resources/views/panic-buttons/show.blade.php ENDPATH**/ ?>