<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HomeSetting;
use Illuminate\Support\Str;

class HomeSettingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $settings = HomeSetting::all();
        return view('admin.home_setting.index', compact('settings'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $setting = HomeSetting::findOrFail($id);
        return view('admin.home_setting.edit', compact('setting'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $setting = HomeSetting::findOrFail($id);
        if (in_array($setting->key, ['logo_url', 'background_url'])) {
            if ($request->hasFile('image')) {
                // Handle file upload
                $file = $request->file('image');
                $filename = $setting->key . '_' . time() . '.' . $file->getClientOriginalExtension();
                
                // Store file directly to public/uploads/home_setting
                $file->move(public_path('uploads/home_setting'), $filename);
                
                // Remove old file if exists and different
                if ($request->old_value && file_exists(public_path($request->old_value)) && $request->old_value !== ('uploads/home_setting/' . $filename)) {
                    @unlink(public_path($request->old_value));
                }
                
                $setting->update(['value' => 'uploads/home_setting/' . $filename]);
            } else {
                // No new file, keep old value
                $setting->update(['value' => $request->old_value]);
            }
        } else {
            $setting->update(['value' => $request->value]);
        }
        return redirect()->route('admin.home-setting.index')->with('success', 'Pengaturan berhasil diupdate.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
