<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Pengumuman;
use App\Models\Berita;
use App\Models\Pengaduan;
use App\Models\Aparatur;
use App\Models\Galeri;
use App\Models\Anggaran;

class AdminController extends Controller
{
    public function dashboard()
    {
        $data = [
            'total_pengumuman' => Pengumuman::count(),
            'total_berita' => Berita::count(),
            'total_pengaduan' => Pengaduan::count(),
            'total_aparatur' => Aparatur::count(),
            'total_galeri' => Galeri::count(),
            'total_anggaran' => Anggaran::count(),
            'pengaduan_terbaru' => Pengaduan::latest()->take(5)->get(),
            'pengumuman_terbaru' => Pengumuman::latest()->take(5)->get(),
        ];

        return view('admin.dashboard', $data);
    }
} 