<?php

namespace App\Http\Controllers;

use App\Models\Anggaran;
use Illuminate\Http\Request;

class AnggaranController extends Controller
{
    public function index()
    {
        $anggarans = Anggaran::orderBy('tahun', 'desc')->orderBy('jenis', 'asc')->paginate(10);
        return view('admin.anggaran.index', compact('anggarans'));
    }

    public function create()
    {
        return view('admin.anggaran.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'tahun' => 'required|string|max:4',
            'jenis' => 'required|string|max:50',
            'total_anggaran' => 'required|numeric|min:0',
            'realisasi' => 'nullable|numeric|min:0',
            'keterangan' => 'nullable|string',
        ]);

        Anggaran::create($request->all());

        return redirect()->route('admin.anggaran.index')->with('success', 'Anggaran berhasil ditambahkan');
    }

    public function show(Anggaran $anggaran)
    {
        return view('admin.anggaran.show', compact('anggaran'));
    }

    public function edit(Anggaran $anggaran)
    {
        return view('admin.anggaran.edit', compact('anggaran'));
    }

    public function update(Request $request, Anggaran $anggaran)
    {
        $request->validate([
            'tahun' => 'required|string|max:4',
            'jenis' => 'required|string|max:50',
            'total_anggaran' => 'required|numeric|min:0',
            'realisasi' => 'nullable|numeric|min:0',
            'keterangan' => 'nullable|string',
        ]);

        $anggaran->update($request->all());

        return redirect()->route('admin.anggaran.index')->with('success', 'Anggaran berhasil diperbarui');
    }

    public function destroy(Anggaran $anggaran)
    {
        $anggaran->delete();

        return redirect()->route('admin.anggaran.index')->with('success', 'Anggaran berhasil dihapus');
    }
}
