<?php

namespace App\Http\Controllers;

use App\Models\Aparatur;
use Illuminate\Http\Request;

class AparaturController extends Controller
{
    public function index()
    {
        $aparaturs = Aparatur::orderBy('urutan', 'asc')->paginate(10);
        return view('admin.aparatur.index', compact('aparaturs'));
    }

    public function create()
    {
        return view('admin.aparatur.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
            'jabatan' => 'required|string|max:255',
            'foto' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'deskripsi' => 'nullable|string',
            'email' => 'nullable|email|max:255',
            'telepon' => 'nullable|string|max:20',
        ]);

        $data = $request->all();
        
        if ($request->hasFile('foto')) {
            $foto = $request->file('foto');
            $namaFoto = time() . '.' . $foto->getClientOriginalExtension();
            $foto->move(public_path('uploads/aparatur'), $namaFoto);
            $data['foto'] = 'uploads/aparatur/' . $namaFoto;
        }

        Aparatur::create($data);

        return redirect()->route('admin.aparatur.index')->with('success', 'Aparatur berhasil ditambahkan');
    }

    public function show(Aparatur $aparatur)
    {
        return view('admin.aparatur.show', compact('aparatur'));
    }

    public function edit(Aparatur $aparatur)
    {
        return view('admin.aparatur.edit', compact('aparatur'));
    }

    public function update(Request $request, Aparatur $aparatur)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
            'jabatan' => 'required|string|max:255',
            'foto' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'deskripsi' => 'nullable|string',
            'email' => 'nullable|email|max:255',
            'telepon' => 'nullable|string|max:20',
        ]);

        $data = $request->all();
        
        if ($request->hasFile('foto')) {
            if ($aparatur->foto && file_exists(public_path($aparatur->foto))) {
                unlink(public_path($aparatur->foto));
            }
            
            $foto = $request->file('foto');
            $namaFoto = time() . '.' . $foto->getClientOriginalExtension();
            $foto->move(public_path('uploads/aparatur'), $namaFoto);
            $data['foto'] = 'uploads/aparatur/' . $namaFoto;
        }

        $aparatur->update($data);

        return redirect()->route('admin.aparatur.index')->with('success', 'Aparatur berhasil diperbarui');
    }

    public function destroy(Aparatur $aparatur)
    {
        if ($aparatur->foto && file_exists(public_path($aparatur->foto))) {
            unlink(public_path($aparatur->foto));
        }
        
        $aparatur->delete();

        return redirect()->route('admin.aparatur.index')->with('success', 'Aparatur berhasil dihapus');
    }
}
