<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Berita;
use App\Models\Pengumuman;
use App\Models\Galeri;
use App\Models\Aparatur;
use App\Models\HomeSetting;

class HomeController extends Controller
{
    public function index()
    {
        $berita = Berita::latest()->take(4)->get();
        $pengumuman = Pengumuman::latest()->take(3)->get();
        $galeri = Galeri::latest()->take(6)->get();
        $aparatur = Aparatur::all();
        $settings = HomeSetting::pluck('value', 'key')->toArray();
        return view('home', compact('berita', 'pengumuman', 'galeri', 'aparatur', 'settings'));
    }
} 