<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\HomeSetting;

class HomeSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            [
                'key' => 'site_title',
                'value' => 'Website Desa Maju'
            ],
            [
                'key' => 'site_description',
                'value' => 'Website resmi desa yang menyediakan informasi dan layanan untuk warga desa.'
            ],
            [
                'key' => 'welcome_message',
                'value' => 'Selamat datang di Website Desa Maju. Kami berkomitmen untuk memberikan pelayanan terbaik kepada seluruh warga desa.'
            ],
            [
                'key' => 'contact_email',
                'value' => 'admin@desamaju.com'
            ],
            [
                'key' => 'contact_phone',
                'value' => '+62 123 456 789'
            ],
            [
                'key' => 'contact_address',
                'value' => 'Jl. Desa Maju No. 123, Kecamatan Maju, Kabupaten Maju, Provinsi Maju'
            ],
            [
                'key' => 'facebook_url',
                'value' => 'https://facebook.com/desamaju'
            ],
            [
                'key' => 'instagram_url',
                'value' => 'https://instagram.com/desamaju'
            ],
            [
                'key' => 'youtube_url',
                'value' => 'https://youtube.com/desamaju'
            ],
            [
                'key' => 'footer_text',
                'value' => '© 2024 Website Desa Maju. Semua hak dilindungi.'
            ],
            [
                'key' => 'hero_title',
                'value' => 'Desa Maju'
            ],
            [
                'key' => 'hero_subtitle',
                'value' => 'Membangun Desa yang Maju, Mandiri, dan Sejahtera'
            ],
            [
                'key' => 'about_section_title',
                'value' => 'Tentang Desa Kami'
            ],
            [
                'key' => 'about_section_content',
                'value' => 'Desa Maju adalah desa yang terletak di Kecamatan Maju, Kabupaten Maju. Desa ini memiliki potensi alam yang melimpah dan masyarakat yang ramah serta gotong royong.'
            ],
            [
                'key' => 'services_section_title',
                'value' => 'Layanan Kami'
            ],
            [
                'key' => 'services_section_subtitle',
                'value' => 'Berbagai layanan yang kami sediakan untuk warga desa'
            ],
            [
                'key' => 'logo_url',
                'value' => 'https://storage.googleapis.com/a1aa/image/logo-desa.png'
            ],
            [
                'key' => 'background_url',
                'value' => 'https://storage.googleapis.com/a1aa/image/background-desa.jpg'
            ]
        ];

        foreach ($settings as $setting) {
            HomeSetting::updateOrCreate(
                ['key' => $setting['key']],
                ['value' => $setting['value']]
            );
        }
    }
} 