@extends('admin.layouts.app')

@section('title', 'Edit Aparatur')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Edit Aparatur</h2>
            <a href="{{ route('admin.aparatur.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('admin.aparatur.update', $aparatur) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="mb-3">
                            <label for="nama" class="form-label">Nama Aparatur <span class="text-danger">*</span></label>
                            <input type="text" name="nama" id="nama" value="{{ old('nama', $aparatur->nama) }}" class="form-control @error('nama') is-invalid @enderror" placeholder="Masukkan nama aparatur">
                            @error('nama')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label for="jabatan" class="form-label">Jabatan <span class="text-danger">*</span></label>
                            <input type="text" name="jabatan" id="jabatan" value="{{ old('jabatan', $aparatur->jabatan) }}" class="form-control @error('jabatan') is-invalid @enderror" placeholder="Masukkan jabatan">
                            @error('jabatan')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label for="foto" class="form-label">Foto Aparatur</label>
                            @if($aparatur->foto)
                                <div class="mb-3">
                                    <p class="form-text mb-2">Foto saat ini:</p>
                                    <img src="{{ asset($aparatur->foto) }}" alt="Foto saat ini" class="rounded border" style="width:100px; height:100px; object-fit:cover;">
                                </div>
                            @endif
                            <input type="file" name="foto" id="foto" class="form-control @error('foto') is-invalid @enderror" accept="image/*">
                            <div class="form-text">Format: JPG, PNG, GIF (Max: 2MB)</div>
                            @error('foto')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="d-flex justify-content-end gap-2">
                            <a href="{{ route('admin.aparatur.index') }}" class="btn btn-outline-secondary">Batal</a>
                            <button type="submit" class="btn btn-success"><i class="fas fa-save me-2"></i>Update Aparatur</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 