@extends('admin.layouts.app')

@section('title', 'Kelola Aparatur')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Kelola Aparatur</h2>
            <a href="{{ route('admin.aparatur.create') }}" class="btn btn-success">
                <i class="fas fa-plus me-2"></i>Tambah Aparatur
            </a>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if(isset($aparatur) && $aparatur->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Nama</th>
                                        <th>Jabatan</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($aparatur as $item)
                                    <tr>
                                        <td>{{ $item->nama }}</td>
                                        <td>{{ $item->jabatan }}</td>
                                        <td>
                                            <a href="{{ route('admin.aparatur.edit', $item) }}" class="btn btn-sm btn-primary"><i class="fas fa-edit"></i></a>
                                            <form action="{{ route('admin.aparatur.destroy', $item) }}" method="POST" class="d-inline" onsubmit="return confirm('Yakin hapus data ini?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            {{ $aparatur->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-users fa-4x text-secondary mb-3"></i>
                            <h5 class="mb-2">Belum ada aparatur</h5>
                            <p class="text-muted mb-4">Mulai dengan menambahkan data aparatur pertama.</p>
                            <a href="{{ route('admin.aparatur.create') }}" class="btn btn-success">
                                Tambah Aparatur Pertama
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 