@extends('admin.layouts.app')

@section('title', 'Detail Aparatur')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Detail Aparatur</h2>
            <div class="d-flex gap-2">
                <a href="{{ route('admin.aparatur.edit', $aparatur) }}" class="btn btn-primary">
                    <i class="fas fa-edit me-2"></i>Edit
                </a>
                <a href="{{ route('admin.aparatur.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Kembali
                </a>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12 col-lg-8 mx-auto">
            <div class="card mb-4">
                <div class="card-body">
                    <h3 class="mb-2">{{ $aparatur->nama }}</h3>
                    <div class="mb-3 text-muted small">
                        <span class="me-3"><i class="fas fa-user-tie me-1"></i> {{ $aparatur->jabatan }}</span>
                    </div>
                    @if($aparatur->foto)
                        <div class="mb-4">
                            <h6 class="mb-2">Foto Aparatur</h6>
                            <img src="{{ asset($aparatur->foto) }}" alt="Foto Aparatur" class="img-fluid rounded shadow-sm" style="max-width:200px;">
                        </div>
                    @endif
                    <div class="row g-3 border-top pt-3">
                        <div class="col-md-6">
                            <h6>Informasi Tambahan</h6>
                            <ul class="list-unstyled mb-0 small">
                                <li><strong>ID:</strong> {{ $aparatur->id }}</li>
                                <li><strong>Dibuat:</strong> {{ $aparatur->created_at ? $aparatur->created_at->format('d/m/Y H:i') : '-' }}</li>
                                <li><strong>Diupdate:</strong> {{ $aparatur->updated_at ? $aparatur->updated_at->format('d/m/Y H:i') : '-' }}</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6>Aksi</h6>
                            <div class="d-grid gap-2">
                                <a href="{{ route('admin.aparatur.edit', $aparatur) }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-edit me-2"></i>Edit Aparatur
                                </a>
                                <form action="{{ route('admin.aparatur.destroy', $aparatur) }}" method="POST" onsubmit="return confirm('Apakah Anda yakin ingin menghapus aparatur ini?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm">
                                        <i class="fas fa-trash me-2"></i>Hapus Aparatur
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 