@extends('admin.layouts.app')

@section('title', 'Detail Berita')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Detail Berita</h2>
            <div class="d-flex gap-2">
                <a href="{{ route('admin.berita.edit', $berita) }}" class="btn btn-primary">
                    <i class="fas fa-edit me-2"></i>Edit
                </a>
                <a href="{{ route('admin.berita.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Kembali
                </a>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12 col-lg-8 mx-auto">
            <div class="card mb-4">
                <div class="card-body">
                    <h3 class="mb-2">{{ $berita->judul }}</h3>
                    <div class="mb-3 text-muted small">
                        <span class="me-3"><i class="fas fa-user me-1"></i> {{ $berita->author }}</span>
                        <span class="me-3"><i class="fas fa-calendar me-1"></i> {{ $berita->created_at ? $berita->created_at->format('d/m/Y H:i') : '-' }}</span>
                    </div>
                    @if($berita->gambar)
                        <div class="mb-4">
                            <h6 class="mb-2">Gambar Berita</h6>
                            <img src="{{ asset($berita->gambar) }}" alt="Gambar Berita" class="img-fluid rounded shadow-sm" style="max-width:350px;">
                        </div>
                    @endif
                    <div class="mb-4">
                        <h6 class="mb-2">Isi Berita</h6>
                        <div class="bg-light p-3 rounded">
                            {!! nl2br(e($berita->isi)) !!}
                        </div>
                    </div>
                    <div class="row g-3 border-top pt-3">
                        <div class="col-md-6">
                            <h6>Informasi Tambahan</h6>
                            <ul class="list-unstyled mb-0 small">
                                <li><strong>ID:</strong> {{ $berita->id }}</li>
                                <li><strong>Dibuat:</strong> {{ $berita->created_at ? $berita->created_at->format('d/m/Y H:i') : '-' }}</li>
                                <li><strong>Diupdate:</strong> {{ $berita->updated_at ? $berita->updated_at->format('d/m/Y H:i') : '-' }}</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6>Aksi</h6>
                            <div class="d-grid gap-2">
                                <a href="{{ route('admin.berita.edit', $berita) }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-edit me-2"></i>Edit Berita
                                </a>
                                <form action="{{ route('admin.berita.destroy', $berita) }}" method="POST" onsubmit="return confirm('Apakah Anda yakin ingin menghapus berita ini?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm">
                                        <i class="fas fa-trash me-2"></i>Hapus Berita
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 