@extends('admin.layouts.app')

@section('title', 'Kelola Galeri')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Kelola Galeri</h2>
            <a href="{{ route('admin.galeri.create') }}" class="btn btn-success">
                <i class="fas fa-plus me-2"></i>Tambah Galeri
            </a>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if(isset($galeri) && $galeri->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Judul</th>
                                        <th>Gambar</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($galeri as $item)
                                    <tr>
                                        <td>{{ $item->judul }}</td>
                                        <td>
                                            @if($item->gambar)
                                                <img src="{{ asset($item->gambar) }}" alt="Gambar" class="rounded" style="width:60px; height:60px; object-fit:cover;">
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.galeri.edit', $item) }}" class="btn btn-sm btn-primary"><i class="fas fa-edit"></i></a>
                                            <form action="{{ route('admin.galeri.destroy', $item) }}" method="POST" class="d-inline" onsubmit="return confirm('Yakin hapus data ini?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            {{ $galeri->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-images fa-4x text-secondary mb-3"></i>
                            <h5 class="mb-2">Belum ada galeri</h5>
                            <p class="text-muted mb-4">Mulai dengan menambahkan foto kegiatan pertama.</p>
                            <a href="{{ route('admin.galeri.create') }}" class="btn btn-success">
                                Tambah Foto Pertama
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 