@extends('admin.layouts.app')
@section('title', 'Edit Pengaturan Home')
@section('content')
<div class="card">
    <div class="card-header bg-gradient-primary text-white">
        <h5 class="mb-0">Edit Pengaturan: {{ $setting->key }}</h5>
    </div>
    <div class="card-body">
        <form action="{{ route('admin.home-setting.update', $setting->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="mb-3">
                <label for="value" class="form-label">Value</label>
                @if(in_array($setting->key, ['logo_url', 'background_url']))
                    @if($setting->value)
                        <div class="mb-2">
                            <img src="{{ asset($setting->value) }}" alt="{{ $setting->key }}" style="max-width:200px;max-height:200px;">
                        </div>
                    @endif
                    <input type="file" name="image" class="form-control" accept="image/*">
                    <input type="hidden" name="old_value" value="{{ $setting->value }}">
                @else
                    <textarea name="value" id="value" class="form-control" rows="5">{{ old('value', $setting->value) }}</textarea>
                @endif
            </div>
            <button type="submit" class="btn btn-success">Simpan</button>
            <a href="{{ route('admin.home-setting.index') }}" class="btn btn-secondary">Kembali</a>
        </form>
    </div>
</div>
@endsection 