<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

  <link rel="apple-touch-icon" sizes="76x76" href="{{ asset('assets/img/apple-icon.png') }}">
  <link rel="icon" type="image/png" href="{{ asset('assets/img/favicon.png') }}">
  <title>
    @yield('title', 'Admin Panel') - Website Desa
  </title>
  <!--     Fonts and icons     -->
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet" />
  <!-- Nucleo Icons -->
  <link href="{{ asset('assets/css/nucleo-icons.css') }}" rel="stylesheet" />
  <link href="{{ asset('assets/css/nucleo-svg.css') }}" rel="stylesheet" />
  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" />
  <!-- CSS Files -->
  <link id="pagestyle" href="{{ asset('assets/css/soft-ui-dashboard.css?v=1.0.3') }}" rel="stylesheet" />
</head>

<body class="g-sidenav-show bg-gray-100">
  @auth
    <!-- Sidebar Start -->
    <aside class="sidenav navbar navbar-vertical navbar-expand-xs border-0 border-radius-xl fixed-start" id="sidenav-main" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); height: 100vh; min-height: 100vh;">
      <div class="sidenav-header d-flex align-items-center justify-content-center py-4">
        <a href="{{ route('admin.dashboard') }}" class="navbar-brand d-flex align-items-center m-0 p-0 text-wrap" style="gap: 0.75rem; text-decoration: none;">
          <span class="icon icon-shape icon-sm bg-white shadow text-center border-radius-md d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
            <i class="fas fa-home text-primary text-gradient opacity-10 fs-5" aria-hidden="true"></i>
          </span>
          <span class="font-weight-bold text-white fs-5" style="letter-spacing: 1px;">Admin Desa</span>
        </a>
      </div>
      <hr class="horizontal light mt-0 mb-2">
      <div class="sidebar-menu-scroll flex-grow-1 d-flex flex-column" style="height: calc(100vh - 90px);">
        <ul class="navbar-nav flex-column sidebar-scroll flex-grow-1">
          <li class="nav-item">
            <a class="nav-link {{ (Request::is('admin/dashboard') ? 'active bg-white bg-opacity-10 text-primary' : 'text-white') }}" href="{{ route('admin.dashboard') }}">
              <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center me-2 d-flex align-items-center justify-content-center">
                <i class="fas fa-tachometer-alt {{ (Request::is('admin/dashboard') ? 'text-primary' : 'text-secondary') }} text-gradient opacity-10" aria-hidden="true"></i>
              </div>
              <span class="nav-link-text ms-1">Dashboard</span>
            </a>
          </li>
          <li class="nav-item mt-3">
            <h6 class="ps-4 ms-2 text-uppercase text-xs font-weight-bolder text-white opacity-8">Konten Website</h6>
          </li>
          <li class="nav-item">
            <a class="nav-link {{ (Request::is('admin/pengumuman*') ? 'active bg-white bg-opacity-10 text-primary' : 'text-white') }}" href="{{ route('admin.pengumuman.index') }}">
              <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center me-2 d-flex align-items-center justify-content-center">
                <i class="fas fa-bullhorn {{ (Request::is('admin/pengumuman*') ? 'text-primary' : 'text-secondary') }} text-gradient opacity-10" aria-hidden="true"></i>
              </div>
              <span class="nav-link-text ms-1">Pengumuman</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link {{ (Request::is('admin/berita*') ? 'active bg-white bg-opacity-10 text-primary' : 'text-white') }}" href="{{ route('admin.berita.index') }}">
              <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center me-2 d-flex align-items-center justify-content-center">
                <i class="fas fa-newspaper {{ (Request::is('admin/berita*') ? 'text-primary' : 'text-secondary') }} text-gradient opacity-10" aria-hidden="true"></i>
              </div>
              <span class="nav-link-text ms-1">Berita</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link {{ (Request::is('admin/aparatur*') ? 'active bg-white bg-opacity-10 text-primary' : 'text-white') }}" href="{{ route('admin.aparatur.index') }}">
              <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center me-2 d-flex align-items-center justify-content-center">
                <i class="fas fa-users {{ (Request::is('admin/aparatur*') ? 'text-primary' : 'text-secondary') }} text-gradient opacity-10" aria-hidden="true"></i>
              </div>
              <span class="nav-link-text ms-1">Aparatur Desa</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link {{ (Request::is('admin/galeri*') ? 'active bg-white bg-opacity-10 text-primary' : 'text-white') }}" href="{{ route('admin.galeri.index') }}">
              <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center me-2 d-flex align-items-center justify-content-center">
                <i class="fas fa-images {{ (Request::is('admin/galeri*') ? 'text-primary' : 'text-secondary') }} text-gradient opacity-10" aria-hidden="true"></i>
              </div>
              <span class="nav-link-text ms-1">Galeri</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link {{ (Request::is('admin/anggaran*') ? 'active bg-white bg-opacity-10 text-primary' : 'text-white') }}" href="{{ route('admin.anggaran.index') }}">
              <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center me-2 d-flex align-items-center justify-content-center">
                <i class="fas fa-chart-pie {{ (Request::is('admin/anggaran*') ? 'text-primary' : 'text-secondary') }} text-gradient opacity-10" aria-hidden="true"></i>
              </div>
              <span class="nav-link-text ms-1">Anggaran</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link {{ (Request::is('admin/home-setting*') ? 'active bg-white bg-opacity-10 text-primary' : 'text-white') }}" href="{{ route('admin.home-setting.index') }}">
              <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center me-2 d-flex align-items-center justify-content-center">
                <i class="fas fa-cog {{ (Request::is('admin/home-setting*') ? 'text-primary' : 'text-secondary') }} text-gradient opacity-10" aria-hidden="true"></i>
              </div>
              <span class="nav-link-text ms-1">Pengaturan Home</span>
            </a>
          </li>
          <li class="nav-item mt-3">
            <h6 class="ps-4 ms-2 text-uppercase text-xs font-weight-bolder text-white opacity-8">Layanan Warga</h6>
          </li>
          <li class="nav-item">
            <a class="nav-link {{ (Request::is('admin/pengaduan*') ? 'active bg-white bg-opacity-10 text-primary' : 'text-white') }}" href="{{ route('admin.pengaduan.index') }}">
              <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center me-2 d-flex align-items-center justify-content-center">
                <i class="fas fa-comments {{ (Request::is('admin/pengaduan*') ? 'text-primary' : 'text-secondary') }} text-gradient opacity-10" aria-hidden="true"></i>
              </div>
              <span class="nav-link-text ms-1">Pengaduan</span>
            </a>
          </li>
          <li class="nav-item mt-3">
            <h6 class="ps-4 ms-2 text-uppercase text-xs font-weight-bolder text-white opacity-8">Akun</h6>
          </li>
          <li class="nav-item">
            <a class="nav-link text-white" href="{{ route('admin.logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
              <div class="icon icon-shape icon-sm shadow border-radius-md bg-white text-center me-2 d-flex align-items-center justify-content-center">
                <i class="fas fa-sign-out-alt text-danger text-gradient opacity-10" aria-hidden="true"></i>
              </div>
              <span class="nav-link-text ms-1">Logout</span>
            </a>
            <form id="logout-form" action="{{ route('admin.logout') }}" method="POST" class="d-none">
              @csrf
            </form>
          </li>
        </ul>
      </div>
    </aside>
    <!-- Sidebar End -->
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg">
      @include('admin.layouts.navbars.auth.nav')
      <div class="container-fluid py-4">
        @if(session('success'))
          <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>
        @endif

        @if(session('error'))
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>
        @endif

        @yield('content')
        @include('admin.layouts.footers.auth.footer')
      </div>
    </main>
  @endauth

  <style>
  .sidenav {
    box-shadow: 0 0 35px 0 rgba(0, 0, 0, 0.1);
    position: fixed;
    left: 0;
    top: 0;
    height: 100vh;
    min-height: 100vh;
    z-index: 1040;
    display: flex;
    flex-direction: column;
  }
  .sidenav-header {
    padding: 1.5rem 0 1rem 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
  }
  .sidenav .navbar-brand {
    gap: 0.75rem;
  }
  .sidenav .icon-shape {
    width: 40px;
    height: 40px;
    font-size: 1.25rem;
  }
  .sidenav .font-weight-bold {
    font-weight: 700 !important;
  }
  .sidenav .fs-5 {
    font-size: 1.15rem;
  }
  .text-gradient {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
  }
  .sidebar-menu-scroll {
    flex: 1 1 auto;
    min-height: 0;
    display: flex;
    flex-direction: column;
  }
  /* Hide scrollbar elements */
  .ps__rail-x,
  .ps__rail-y,
  .ps__thumb-x,
  .ps__thumb-y {
    display: none !important;
  }
  .ps {
    overflow: visible !important;
  }
  .sidenav {
    overflow: visible !important;
  }
  .sidenav .collapse {
    overflow: visible !important;
  }
  .sidenav .navbar-nav {
    overflow: visible !important;
  }
  /* SCROLLABLE SIDEBAR MENU */
  .sidebar-scroll {
    flex: 1 1 auto;
    min-height: 0;
    max-height: 100%;
    overflow-y: auto;
    overflow-x: hidden;
    scrollbar-width: thin;
    scrollbar-color: #b3b3b3 #f5f5f5;
  }
  .sidebar-scroll::-webkit-scrollbar {
    width: 7px;
    background: #f5f5f5;
  }
  .sidebar-scroll::-webkit-scrollbar-thumb {
    background: #b3b3b3;
    border-radius: 6px;
  }
  .sidebar-scroll::-webkit-scrollbar-thumb:hover {
    background: #888;
  }
  </style>

  <!--   Core JS Files   -->
  <script src="{{ asset('assets/js/core/popper.min.js') }}"></script>
  <script src="{{ asset('assets/js/core/bootstrap.min.js') }}"></script>
  <script src="{{ asset('assets/js/plugins/perfect-scrollbar.min.js') }}"></script>
  <script src="{{ asset('assets/js/plugins/smooth-scrollbar.min.js') }}"></script>
  <script src="{{ asset('assets/js/plugins/fullcalendar.min.js') }}"></script>
  <script src="{{ asset('assets/js/plugins/chartjs.min.js') }}"></script>
  @stack('rtl')
  @stack('dashboard')
  <script>
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
      var options = {
        damping: '0.5'
      }
      Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
  </script>

  <!-- Github buttons -->
  <script async defer src="https://buttons.github.io/buttons.js"></script>
  <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
  <script src="{{ asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3') }}"></script>
</body>

</html> 