@extends('admin.layouts.app')

@section('title', 'Kelola Pengaduan')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Kelola Pengaduan</h2>
            <a href="{{ route('admin.pengaduan.create') }}" class="btn btn-success">
                <i class="fas fa-plus me-2"></i>Tambah Pengaduan
            </a>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if(isset($pengaduan) && $pengaduan->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Nama</th>
                                        <th>Isi Pengaduan</th>
                                        <th>Tanggal</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($pengaduan as $item)
                                    <tr>
                                        <td>{{ $item->nama }}</td>
                                        <td>{{ Str::limit($item->isi, 50) }}</td>
                                        <td>{{ $item->created_at ? $item->created_at->format('d/m/Y H:i') : '-' }}</td>
                                        <td>
                                            <a href="{{ route('admin.pengaduan.show', $item) }}" class="btn btn-sm btn-info"><i class="fas fa-eye"></i></a>
                                            <form action="{{ route('admin.pengaduan.destroy', $item) }}" method="POST" class="d-inline" onsubmit="return confirm('Yakin hapus data ini?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            {{ $pengaduan->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-comment-alt fa-4x text-secondary mb-3"></i>
                            <h5 class="mb-2">Belum ada pengaduan</h5>
                            <p class="text-muted mb-4">Belum ada pengaduan dari warga.</p>
                            <a href="{{ route('admin.pengaduan.create') }}" class="btn btn-success">
                                Tambah Pengaduan
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 