@extends('admin.layouts.app')

@section('title', 'Edit Pengumuman')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Edit Pengumuman</h2>
            <a href="{{ route('admin.pengumuman.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('admin.pengumuman.update', $pengumuman) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="row g-3">
                            <div class="col-12">
                                <label for="judul" class="form-label">Judul Pengumuman <span class="text-danger">*</span></label>
                                <input type="text" name="judul" id="judul" value="{{ old('judul', $pengumuman->judul) }}" class="form-control @error('judul') is-invalid @enderror" placeholder="Masukkan judul pengumuman">
                                @error('judul')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="author" class="form-label">Penulis</label>
                                <input type="text" name="author" id="author" value="{{ old('author', $pengumuman->author) }}" class="form-control @error('author') is-invalid @enderror" placeholder="Nama penulis">
                                @error('author')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="is_active" class="form-label">Status</label>
                                <select name="is_active" id="is_active" class="form-select @error('is_active') is-invalid @enderror">
                                    <option value="1" {{ old('is_active', $pengumuman->is_active) == '1' ? 'selected' : '' }}>Aktif</option>
                                    <option value="0" {{ old('is_active', $pengumuman->is_active) == '0' ? 'selected' : '' }}>Nonaktif</option>
                                </select>
                                @error('is_active')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-12">
                                <label for="gambar" class="form-label">Gambar Pengumuman</label>
                                @if($pengumuman->gambar)
                                    <div class="mb-3">
                                        <p class="form-text mb-2">Gambar saat ini:</p>
                                        <img src="{{ asset($pengumuman->gambar) }}" alt="Gambar saat ini" class="rounded border" style="width:100px; height:100px; object-fit:cover;">
                                    </div>
                                @endif
                                <input type="file" name="gambar" id="gambar" accept="image/*" class="form-control @error('gambar') is-invalid @enderror">
                                <div class="form-text">Format: JPG, PNG, GIF (Max: 2MB)</div>
                                @error('gambar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-12">
                                <label for="isi" class="form-label">Isi Pengumuman <span class="text-danger">*</span></label>
                                <textarea name="isi" id="isi" rows="8" class="form-control @error('isi') is-invalid @enderror" placeholder="Tulis isi pengumuman di sini...">{{ old('isi', $pengumuman->isi) }}</textarea>
                                @error('isi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="d-flex justify-content-end gap-2 mt-4">
                            <a href="{{ route('admin.pengumuman.index') }}" class="btn btn-outline-secondary">Batal</a>
                            <button type="submit" class="btn btn-success"><i class="fas fa-save me-2"></i>Update Pengumuman</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 