@extends('admin.layouts.app')

@section('title', 'Kelola Pengumuman')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Kelola Pengumuman</h2>
            <a href="{{ route('admin.pengumuman.create') }}" class="btn btn-success">
                <i class="fas fa-plus me-2"></i>Tambah Pengumuman
            </a>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if($pengumumen->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Judul</th>
                                        <th>Author</th>
                                        <th>Status</th>
                                        <th>Tanggal</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($pengumumen as $pengumuman)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                @if($pengumuman->gambar)
                                                    <img src="{{ asset($pengumuman->gambar) }}" alt="Gambar" class="rounded me-3" style="width:40px; height:40px; object-fit:cover;">
                                                @else
                                                    <div class="rounded bg-light d-flex align-items-center justify-content-center me-3" style="width:40px; height:40px;">
                                                        <i class="fas fa-image text-secondary"></i>
                                                    </div>
                                                @endif
                                                <div>
                                                    <div class="fw-bold">{{ $pengumuman->judul }}</div>
                                                    <div class="text-muted small">{{ Str::limit($pengumuman->isi, 50) }}</div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ $pengumuman->author }}</td>
                                        <td>
                                            @if($pengumuman->is_active)
                                                <span class="badge bg-success">Aktif</span>
                                            @else
                                                <span class="badge bg-danger">Nonaktif</span>
                                            @endif
                                        </td>
                                        <td>{{ $pengumuman->published_at ? $pengumuman->published_at->format('d/m/Y H:i') : '-' }}</td>
                                        <td>
                                            <a href="{{ route('admin.pengumuman.show', $pengumuman) }}" class="btn btn-sm btn-info"><i class="fas fa-eye"></i></a>
                                            <a href="{{ route('admin.pengumuman.edit', $pengumuman) }}" class="btn btn-sm btn-primary"><i class="fas fa-edit"></i></a>
                                            <form action="{{ route('admin.pengumuman.destroy', $pengumuman) }}" method="POST" class="d-inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus pengumuman ini?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            {{ $pengumumen->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-bullhorn fa-4x text-secondary mb-3"></i>
                            <h5 class="mb-2">Belum ada pengumuman</h5>
                            <p class="text-muted mb-4">Mulai dengan menambahkan pengumuman pertama Anda.</p>
                            <a href="{{ route('admin.pengumuman.create') }}" class="btn btn-success">
                                Tambah Pengumuman Pertama
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 