@extends('admin.layouts.app')

@section('title', 'Detail Pengumuman')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12 d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Detail Pengumuman</h2>
            <div class="d-flex gap-2">
                <a href="{{ route('admin.pengumuman.edit', $pengumuman) }}" class="btn btn-primary">
                    <i class="fas fa-edit me-2"></i>Edit
                </a>
                <a href="{{ route('admin.pengumuman.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Kembali
                </a>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12 col-lg-8 mx-auto">
            <div class="card mb-4">
                <div class="card-body">
                    <h3 class="mb-2">{{ $pengumuman->judul }}</h3>
                    <div class="mb-3 text-muted small">
                        <span class="me-3"><i class="fas fa-user me-1"></i> {{ $pengumuman->author }}</span>
                        <span class="me-3"><i class="fas fa-calendar me-1"></i> {{ $pengumuman->published_at ? $pengumuman->published_at->format('d/m/Y H:i') : 'Belum dipublikasi' }}</span>
                        <span class="badge {{ $pengumuman->is_active ? 'bg-success' : 'bg-danger' }}">{{ $pengumuman->is_active ? 'Aktif' : 'Nonaktif' }}</span>
                    </div>
                    @if($pengumuman->gambar)
                        <div class="mb-4">
                            <h6 class="mb-2">Gambar Pengumuman</h6>
                            <img src="{{ asset($pengumuman->gambar) }}" alt="Gambar Pengumuman" class="img-fluid rounded shadow-sm" style="max-width:350px;">
                        </div>
                    @endif
                    <div class="mb-4">
                        <h6 class="mb-2">Isi Pengumuman</h6>
                        <div class="bg-light p-3 rounded">
                            {!! nl2br(e($pengumuman->isi)) !!}
                        </div>
                    </div>
                    <div class="row g-3 border-top pt-3">
                        <div class="col-md-6">
                            <h6>Informasi Tambahan</h6>
                            <ul class="list-unstyled mb-0 small">
                                <li><strong>ID:</strong> {{ $pengumuman->id }}</li>
                                <li><strong>Dibuat:</strong> {{ $pengumuman->created_at->format('d/m/Y H:i') }}</li>
                                <li><strong>Diupdate:</strong> {{ $pengumuman->updated_at->format('d/m/Y H:i') }}</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <h6>Aksi</h6>
                            <div class="d-grid gap-2">
                                <a href="{{ route('admin.pengumuman.edit', $pengumuman) }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-edit me-2"></i>Edit Pengumuman
                                </a>
                                <form action="{{ route('admin.pengumuman.destroy', $pengumuman) }}" method="POST" onsubmit="return confirm('Apakah Anda yakin ingin menghapus pengumuman ini?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm">
                                        <i class="fas fa-trash me-2"></i>Hapus Pengumuman
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 