@extends('layouts.app')
@section('content')
<div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 py-4 sm:py-6 lg:py-8">
    <h2 class="text-xl sm:text-2xl font-bold mb-4 sm:mb-6 text-center sm:text-left">Aparatur Desa</h2>
    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-3 sm:gap-4 lg:gap-6">
        @foreach($aparatur as $item)
            <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 flex flex-col items-center hover:shadow-lg transition-shadow">
                @if($item->foto)
                    <img src="{{ asset($item->foto) }}" alt="{{ $item->nama }}" class="rounded-lg mb-2 h-24 sm:h-32 w-full object-cover">
                @else
                    <div class="rounded-lg mb-2 h-24 sm:h-32 w-full bg-gray-200 flex items-center justify-center">
                        <i class="fas fa-user text-gray-400 text-2xl"></i>
                    </div>
                @endif
                <p class="font-semibold text-xs sm:text-sm mb-1 text-center">{{ $item->nama }}</p>
                <p class="text-xs text-gray-500 mb-2 text-center">{{ $item->jabatan }}</p>
                <a href="{{ route('aparatur.detail', $item->id) }}" class="text-[#1dbf4a] hover:text-[#0f9d58] text-xs font-semibold">Lihat Detail →</a>
            </div>
        @endforeach
    </div>
</div>
@endsection 