@extends('layouts.app')
@section('content')
<div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 py-4 sm:py-6 lg:py-8">
    <h2 class="text-xl sm:text-2xl font-bold mb-4 sm:mb-6 text-center sm:text-left">Daftar Berita</h2>
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-6">
        @foreach($berita as $item)
            <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 flex flex-col hover:shadow-lg transition-shadow">
                <img src="{{ $item->gambar ? asset($item->gambar) : 'https://storage.googleapis.com/a1aa/image/e8386500-9792-4430-6e34-b659c6470a30.jpg' }}" alt="{{ $item->judul }}" class="rounded mb-3 h-32 sm:h-40 object-cover w-full">
                <h3 class="font-semibold text-sm sm:text-lg mb-2 line-clamp-2">{{ $item->judul }}</h3>
                <p class="text-xs sm:text-sm text-gray-600 mb-3 flex-grow">{{ Str::limit($item->isi, 100) }}</p>
                <div class="flex justify-between items-center">
                    <span class="text-xs text-gray-500">{{ $item->created_at->format('d/m/Y') }}</span>
                    <a href="{{ route('berita.detail', $item->id) }}" class="text-xs sm:text-sm text-[#1dbf4a] hover:text-[#0f9d58] font-semibold">Baca Selengkapnya →</a>
                </div>
            </div>
        @endforeach
    </div>
    <div class="mt-6 sm:mt-8 flex justify-center">{{ $berita->links() }}</div>
</div>
@endsection 