@extends('layouts.app')
@section('content')
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 py-4 sm:py-6 lg:py-8">
    <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold mb-3 sm:mb-4 text-center sm:text-left">{{ $berita->judul }}</h1>
    <div class="mb-4 sm:mb-6 text-gray-500 text-xs sm:text-sm flex flex-col sm:flex-row sm:items-center gap-2 sm:gap-4 justify-center sm:justify-start">
        <span class="flex items-center gap-1"><i class="fas fa-user"></i> {{ $berita->author }}</span>
        <span class="hidden sm:inline">|</span>
        <span class="flex items-center gap-1"><i class="far fa-calendar-alt"></i> {{ $berita->created_at->format('d/m/Y') }}</span>
    </div>
    @if($berita->gambar)
        <img src="{{ asset($berita->gambar) }}" alt="{{ $berita->judul }}" class="rounded-lg mb-4 sm:mb-6 w-full h-48 sm:h-64 lg:h-96 object-cover shadow-md">
    @endif
    <div class="prose prose-sm sm:prose-base max-w-none text-sm sm:text-base leading-relaxed">
        {!! nl2br(e($berita->isi)) !!}
    </div>
    <div class="mt-6 sm:mt-8 text-center sm:text-left">
        <a href="{{ route('berita.list') }}" class="inline-flex items-center gap-2 text-[#1dbf4a] hover:text-[#0f9d58] font-semibold text-sm sm:text-base">
            <i class="fas fa-arrow-left"></i>
            Kembali ke Daftar Berita
        </a>
    </div>
</div>
@endsection 